/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.faq.repository;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Named;
import org.giavacms.base.model.Page;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.base.repository.AbstractPageRepository;
import org.giavacms.common.model.Search;
import org.giavacms.faq.model.Faq;
import org.giavacms.faq.model.FaqCategory;

@Named
@Stateless
@LocalBean
public class FaqCategoryRepository
extends AbstractPageRepository<FaqCategory> {
    private static final long serialVersionUID = 1L;

    protected String getDefaultOrderBy() {
        return "orderNum asc";
    }

    protected FaqCategory prePersist(FaqCategory n) {
        n.setClone(true);
        return (FaqCategory)super.prePersist((Page)n);
    }

    protected FaqCategory preUpdate(FaqCategory n) {
        n.setClone(true);
        return (FaqCategory)super.preUpdate((Page)n);
    }

    public String translate(String currentLangValue, int currentLang, int alternativeLang, String noValueOption) {
        String alternativeLangValue = null;
        try {
            FaqCategory fq = (FaqCategory)this.find(currentLangValue);
            if (fq != null) {
                switch (alternativeLang) {
                    case 1: {
                        alternativeLangValue = fq.getLang1id();
                        break;
                    }
                    case 2: {
                        alternativeLangValue = fq.getLang2id();
                        break;
                    }
                    case 3: {
                        alternativeLangValue = fq.getLang3id();
                        break;
                    }
                    case 4: {
                        alternativeLangValue = fq.getLang4id();
                        break;
                    }
                    case 5: {
                        alternativeLangValue = fq.getLang5id();
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (alternativeLangValue == null || alternativeLangValue.trim().isEmpty()) {
            alternativeLangValue = noValueOption;
        }
        return alternativeLangValue;
    }

    protected List<FaqCategory> extract(List resultList, boolean completeFetch) {
        FaqCategory faqCategory = null;
        LinkedHashMap<String, HashSet> faqs = new LinkedHashMap<String, HashSet>();
        LinkedHashMap<String, FaqCategory> categories = new LinkedHashMap<String, FaqCategory>();
        Iterator results = resultList.iterator();
        while (results.hasNext()) {
            faqCategory = new FaqCategory();
            Object[] row = (Object[])results.next();
            int i = 0;
            String id = (String)row[i];
            faqCategory.setId(id);
            String lang1id = (String)row[++i];
            faqCategory.setLang1id(lang1id);
            String lang2id = (String)row[++i];
            faqCategory.setLang2id(lang2id);
            String lang3id = (String)row[++i];
            faqCategory.setLang3id(lang3id);
            String lang4id = (String)row[++i];
            faqCategory.setLang4id(lang4id);
            String lang5id = (String)row[++i];
            faqCategory.setLang5id(lang5id);
            Object clone = row[++i];
            if (clone != null) {
                if (clone instanceof Boolean) {
                    faqCategory.setClone((Boolean)clone);
                }
                if (clone instanceof Short) {
                    faqCategory.setClone(((Short)clone).intValue() > 0);
                } else {
                    logger.error((Object)("clone instance of " + clone.getClass().getCanonicalName()));
                }
            } else {
                logger.error((Object)"clone should not be null");
            }
            String title = (String)row[++i];
            faqCategory.setTitle(title);
            String description = (String)row[++i];
            faqCategory.setDescription(description);
            Object template_impl_id = row[++i];
            if (template_impl_id != null) {
                if (template_impl_id instanceof BigInteger) {
                    faqCategory.getTemplate().setId(Long.valueOf(((BigInteger)template_impl_id).longValue()));
                    faqCategory.setTemplateId(((BigInteger)template_impl_id).longValue());
                } else {
                    logger.error((Object)("templateImpl_id instance of " + template_impl_id.getClass().getCanonicalName()));
                }
            } else {
                logger.error((Object)"templateImpl_id should not be null");
            }
            String mainPageId = (String)row[++i];
            faqCategory.getTemplate().setMainPageId(mainPageId);
            String mainPageTitle = (String)row[++i];
            faqCategory.getTemplate().setMainPageTitle(mainPageTitle);
            String imageFilename = (String)row[++i];
            if (imageFilename != null) {
                faqCategory.setImage(new Image());
                faqCategory.getImage().setFilename(imageFilename);
            }
            ++i;
            if (completeFetch) {
                String faqId = (String)row[i];
                Timestamp date = (Timestamp)row[++i];
                Date faqDate = null;
                if (date != null) {
                    faqDate = new Date(date.getTime());
                }
                String faqAnswer = (String)row[++i];
                String faqName = (String)row[++i];
                ++i;
                HashSet category_faqs = null;
                if (faqId != null && !faqId.isEmpty()) {
                    if (faqs.containsKey(id)) {
                        category_faqs = (HashSet)faqs.get(id);
                    } else {
                        category_faqs = new HashSet();
                        faqs.put(id, category_faqs);
                    }
                }
                if (category_faqs != null) {
                    Faq f = new Faq();
                    f.setId(faqId);
                    f.setAnswer(faqAnswer);
                    f.setDate(faqDate);
                    f.setTitle(faqName);
                    category_faqs.add(f);
                }
            }
            if (categories.containsKey(id)) continue;
            categories.put(id, faqCategory);
        }
        if (completeFetch) {
            for (String id : faqs.keySet()) {
                FaqCategory cat = null;
                if (categories.containsKey(id)) {
                    cat = (FaqCategory)((Object)categories.get(id));
                    Set fs = (Set)faqs.get(id);
                    if (fs == null) continue;
                    for (Faq f : fs) {
                        f.setFaqCategory(cat);
                        cat.addFaq(f);
                    }
                    continue;
                }
                logger.error((Object)("ERROR - DOCS CYCLE cannot find id:" + id));
            }
        }
        return new ArrayList<FaqCategory>(categories.values());
    }

    protected StringBuffer getListNative(Search<FaqCategory> search, Map<String, Object> params, boolean count, int startRow, int pageSize, boolean completeFetch) {
        String pageAlias = "P";
        String templateImplAlias = "TI";
        String faqCategoryAlias = "C";
        String imageAlias = "I";
        String faqAlias = "D";
        String faqPageAlias = "PD";
        StringBuffer sb = new StringBuffer("SELECT ");
        if (count) {
            sb.append(" count( distinct ").append(pageAlias).append(".id ) ");
        } else {
            sb.append(pageAlias).append(".id, ");
            sb.append(pageAlias).append(".lang1id, ");
            sb.append(pageAlias).append(".lang2id, ");
            sb.append(pageAlias).append(".lang3id, ");
            sb.append(pageAlias).append(".lang4id, ");
            sb.append(pageAlias).append(".lang5id, ");
            sb.append(pageAlias).append(".clone, ");
            sb.append(pageAlias).append(".title, ");
            sb.append(pageAlias).append(".description, ");
            sb.append(templateImplAlias).append(".id as templateImpl_id, ");
            sb.append(templateImplAlias).append(".mainPageId, ");
            sb.append(templateImplAlias).append(".mainPageTitle, ");
            sb.append(imageAlias).append(".fileName AS image ");
            if (completeFetch) {
                sb.append(", ").append(faqAlias).append(".id AS faqId, ");
                sb.append(faqAlias).append(".date AS faqDate, ");
                sb.append(faqAlias).append(".answer AS faqAnswer, ");
                sb.append(faqPageAlias).append(".title AS faqTitle ");
            }
        }
        sb.append(" FROM ").append("FaqCategory").append(" AS ").append(faqCategoryAlias);
        sb.append(" LEFT JOIN ").append("Page").append(" as ").append(pageAlias).append(" on ( ").append(faqCategoryAlias).append(".id = ").append(pageAlias).append(".id ) ");
        sb.append(" LEFT JOIN ").append("TemplateImpl").append(" as ").append(templateImplAlias).append(" on ( ").append(templateImplAlias).append(".id = ").append(pageAlias).append(".template_id ) ");
        if (!count) {
            sb.append(" LEFT JOIN ").append("Image").append(" as ").append(imageAlias).append(" on ( ").append(imageAlias).append(".id = ").append(faqCategoryAlias).append(".image_id ) ");
            sb.append(" LEFT JOIN ").append("Faq").append(" AS ").append(faqAlias).append(" ON ( ").append(faqAlias).append(".faqCategory_id = ").append(faqCategoryAlias).append(".id ) ");
            sb.append(" LEFT JOIN ").append("Page").append(" AS ").append(faqPageAlias).append(" ON ( ").append(faqAlias).append(".id = ").append(faqPageAlias).append(".id ) ");
        }
        String innerPageAlias = null;
        String innerTemplateImplAlias = null;
        String innerFaqCategoryAlias = null;
        if (count) {
            innerPageAlias = pageAlias;
            innerTemplateImplAlias = templateImplAlias;
            innerFaqCategoryAlias = faqCategoryAlias;
        } else {
            innerPageAlias = "P1";
            innerTemplateImplAlias = "T1";
            innerFaqCategoryAlias = "C1";
            sb.append(" INNER JOIN ");
            sb.append(" ( ");
            sb.append(" select distinct ").append(innerPageAlias).append(".id from ");
            sb.append("FaqCategory").append(" AS ").append(innerFaqCategoryAlias);
            sb.append(" LEFT JOIN ").append("Page").append(" as ").append(innerPageAlias).append(" on ( ").append(innerFaqCategoryAlias).append(".id = ").append(innerPageAlias).append(".id ) ");
            sb.append(" LEFT JOIN ").append("TemplateImpl").append(" as ").append(innerTemplateImplAlias).append(" on ( ").append(innerTemplateImplAlias).append(".id = ").append(innerPageAlias).append(".template_id ) ");
        }
        String separator = " where ";
        this.applyRestrictionsNative(search, innerPageAlias, innerTemplateImplAlias, innerFaqCategoryAlias, separator, sb, params);
        if (!count) {
            sb.append(" order by ").append(innerFaqCategoryAlias).append(".orderNum asc ");
            if (pageSize > 0) {
                sb.append(" limit ").append(startRow).append(", ").append(pageSize).toString();
            }
            sb.append(" ) ");
            sb.append(" as IN2 ON ").append(pageAlias).append(".ID = IN2.ID ");
            sb.append(" order by ").append(faqCategoryAlias).append(".orderNum desc ");
            sb.append(", ").append(faqAlias).append(".date desc ");
        }
        return sb;
    }

    protected void applyRestrictionsNative(Search<FaqCategory> search, String pageAlias, String templateImplAlias, String categoryAlias, String separator, StringBuffer sb, Map<String, Object> params) {
        String customLike = null;
        super.applyRestrictionsNative(search, pageAlias, separator, sb, params, customLike);
    }
}

