/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.faq.repository;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Named;
import org.giavacms.base.common.util.HtmlUtils;
import org.giavacms.base.model.Page;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.base.repository.AbstractPageRepository;
import org.giavacms.common.model.Search;
import org.giavacms.faq.model.Faq;
import org.giavacms.faq.model.FaqCategory;

@Named
@Stateless
@LocalBean
public class FaqRepository
extends AbstractPageRepository<Faq> {
    private static final long serialVersionUID = 1L;

    protected String getDefaultOrderBy() {
        return "faqCategory.orderNum asc,date desc";
    }

    protected Faq prePersist(Faq faq) {
        faq.setClone(true);
        faq.setAnswer(HtmlUtils.normalizeHtml((String)faq.getAnswer()));
        faq.setTitle(HtmlUtils.normalizeHtml((String)faq.getTitle()));
        return (Faq)super.prePersist((Page)faq);
    }

    protected Faq preUpdate(Faq faq) {
        faq.setClone(true);
        faq.setAnswer(HtmlUtils.normalizeHtml((String)faq.getAnswer()));
        faq.setTitle(HtmlUtils.normalizeHtml((String)faq.getTitle()));
        return (Faq)super.preUpdate((Page)faq);
    }

    protected StringBuffer getListNative(Search<Faq> search, Map<String, Object> params, boolean count, int startRow, int pageSize, boolean completeFetch) {
        String pageAlias = "P";
        String templateImplAlias = "T";
        String faqAlias = "F";
        String faqCategoryAlias = "FC";
        String faqCategoryPageAlias = "FCP";
        StringBuffer sb = new StringBuffer("SELECT ");
        if (count) {
            sb.append(" count( distinct ").append(pageAlias).append(".id ) ");
        } else {
            sb.append(pageAlias).append(".id, ");
            sb.append(pageAlias).append(".lang1id, ");
            sb.append(pageAlias).append(".lang2id, ");
            sb.append(pageAlias).append(".lang3id, ");
            sb.append(pageAlias).append(".lang4id, ");
            sb.append(pageAlias).append(".lang5id, ");
            sb.append(pageAlias).append(".clone, ");
            sb.append(pageAlias).append(".title, ");
            sb.append(pageAlias).append(".description, ");
            sb.append(templateImplAlias).append(".id as templateImpl_id, ");
            sb.append(templateImplAlias).append(".mainPageId, ");
            sb.append(templateImplAlias).append(".mainPageTitle, ");
            sb.append(faqAlias).append(".answer, ");
            sb.append(faqAlias).append(".date, ");
            sb.append(faqAlias).append(".faqCategory_id, ");
            sb.append(faqCategoryPageAlias).append(".title AS faqCategoryTitle, ");
            sb.append(faqCategoryAlias).append(".orderNum, ");
            sb.append(" I.fileName AS image ");
            if (completeFetch) {
                // empty if block
            }
        }
        sb.append(" FROM ").append("Faq").append(" AS ").append(faqAlias);
        sb.append(" LEFT JOIN ").append("FaqCategory").append(" AS ").append(faqCategoryAlias).append(" ON ( ").append(faqCategoryAlias).append(".id = ").append(faqAlias).append(".faqCategory_id ) ");
        sb.append(" LEFT JOIN ").append("Page").append(" as ").append(pageAlias).append(" on ( ").append(faqAlias).append(".id = ").append(pageAlias).append(".id ) ");
        sb.append(" LEFT JOIN ").append("Page").append(" as ").append(faqCategoryPageAlias).append(" on ( ").append(faqCategoryAlias).append(".id = ").append(faqCategoryPageAlias).append(".id ) ");
        sb.append(" LEFT JOIN Image as I on ( I.id = ").append(faqCategoryAlias).append(".image_id ) ");
        sb.append(" LEFT JOIN ").append("TemplateImpl").append(" as ").append(templateImplAlias).append(" on ( ").append(templateImplAlias).append(".id = ").append(pageAlias).append(".template_id ) ");
        if (count) {
            // empty if block
        }
        String innerPageAlias = null;
        String innerTemplateImplAlias = null;
        String innerFaqAlias = null;
        String innerFaqCategoryAlias = null;
        String innerFaqCategoryPageAlias = null;
        if (count) {
            innerPageAlias = pageAlias;
            innerTemplateImplAlias = templateImplAlias;
            innerFaqAlias = faqAlias;
            innerFaqCategoryAlias = faqCategoryAlias;
            innerFaqCategoryPageAlias = faqCategoryPageAlias;
        } else {
            innerPageAlias = pageAlias;
            innerTemplateImplAlias = templateImplAlias;
            innerFaqAlias = faqAlias;
            innerFaqCategoryAlias = faqCategoryAlias;
            innerFaqCategoryPageAlias = faqCategoryPageAlias;
        }
        String separator = " where ";
        this.applyRestrictionsNative(search, innerPageAlias, innerTemplateImplAlias, innerFaqAlias, innerFaqCategoryAlias, innerFaqCategoryPageAlias, separator, sb, params);
        if (!count) {
            sb.append(" order by ").append(innerPageAlias).append(".title desc ");
            if (pageSize > 0) {
                sb.append(" limit ").append(startRow).append(", ").append(pageSize).toString();
            }
        }
        return sb;
    }

    protected void applyRestrictionsNative(Search<Faq> search, String pageAlias, String templateImplAlias, String faqAlias, String faqCategoryAlias, String faqCategoryPageAlias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(faqCategoryPageAlias).append(".active = :activeCategory");
        params.put("activeCategory", true);
        separator = " and ";
        if (((Faq)((Object)search.getObj())).getFaqCategory() != null && ((Faq)((Object)search.getObj())).getFaqCategory().getTitle() != null && ((Faq)((Object)search.getObj())).getFaqCategory().getTitle().trim().length() > 0) {
            sb.append(separator).append(faqCategoryPageAlias).append(".title = :NAMECAT ");
            params.put("NAMECAT", ((Faq)((Object)search.getObj())).getFaqCategory().getTitle());
        }
        if (((Faq)((Object)search.getObj())).getFaqCategory() != null && ((Faq)((Object)search.getObj())).getFaqCategory().getId() != null && ((Faq)((Object)search.getObj())).getFaqCategory().getId().trim().length() > 0) {
            sb.append(separator).append(faqCategoryAlias).append(".id = :IDCAT ");
            params.put("IDCAT", ((Faq)((Object)search.getObj())).getFaqCategory().getId());
        }
        if (((Faq)((Object)search.getObj())).getAnswer() != null && !((Faq)((Object)search.getObj())).getAnswer().isEmpty()) {
            sb.append(separator + " upper(").append(faqAlias).append(".answer) LIKE :ANSWER ");
            params.put("ANSWER", this.likeParam(((Faq)((Object)search.getObj())).getAnswer().trim().toUpperCase()));
        }
        String customLike = null;
        super.applyRestrictionsNative(search, pageAlias, separator, sb, params, customLike);
    }

    protected List<Faq> extract(List resultList, boolean completeFetch) {
        ArrayList<Faq> faqs = new ArrayList<Faq>();
        Iterator results = resultList.iterator();
        while (results.hasNext()) {
            faqs.add(this.extract((Object[])results.next(), completeFetch));
        }
        return faqs;
    }

    protected Faq extract(Object[] row, boolean completeFetch) {
        Faq faq = new Faq();
        faq.setActive(true);
        int i = 0;
        String id = (String)row[i];
        faq.setId(id);
        String lang1id = (String)row[++i];
        faq.setLang1id(lang1id);
        String lang2id = (String)row[++i];
        faq.setLang2id(lang2id);
        String lang3id = (String)row[++i];
        faq.setLang3id(lang3id);
        String lang4id = (String)row[++i];
        faq.setLang4id(lang4id);
        String lang5id = (String)row[++i];
        faq.setLang5id(lang5id);
        Object clone = row[++i];
        if (clone != null) {
            if (clone instanceof Boolean) {
                faq.setClone((Boolean)clone);
            }
            if (clone instanceof Short) {
                faq.setClone(((Short)clone).intValue() > 0);
            } else {
                logger.error((Object)("clone instance of " + clone.getClass().getCanonicalName()));
            }
        } else {
            logger.error((Object)"clone should not be null");
        }
        String title = (String)row[++i];
        faq.setTitle(title);
        String description = (String)row[++i];
        faq.setDescription(description);
        Object template_impl_id = row[++i];
        if (template_impl_id != null) {
            if (template_impl_id instanceof BigInteger) {
                faq.getTemplate().setId(Long.valueOf(((BigInteger)template_impl_id).longValue()));
                faq.setTemplateId(((BigInteger)template_impl_id).longValue());
            } else {
                logger.error((Object)("templateImpl_id instance of " + template_impl_id.getClass().getCanonicalName()));
            }
        } else {
            logger.error((Object)"templateImpl_id should not be null");
        }
        String mainPageId = (String)row[++i];
        faq.getTemplate().setMainPageId(mainPageId);
        String mainPageTitle = (String)row[++i];
        faq.getTemplate().setMainPageTitle(mainPageTitle);
        String answer = (String)row[++i];
        faq.setAnswer(answer);
        Timestamp date = (Timestamp)row[++i];
        if (date != null) {
            faq.setDate(new Date(date.getTime()));
        }
        FaqCategory faqCategory = new FaqCategory();
        faqCategory.setActive(true);
        faq.setFaqCategory(faqCategory);
        String categoryId = (String)row[++i];
        faqCategory.setId(categoryId);
        String categoryTitle = (String)row[++i];
        faqCategory.setTitle(categoryTitle);
        Object orderNumer = row[++i];
        if (orderNumer != null) {
            if (orderNumer instanceof Integer) {
                faqCategory.setOrderNum((Integer)row[i]);
            } else {
                logger.error((Object)("orderNum instance of " + orderNumer.getClass().getCanonicalName()));
            }
        }
        if (row[++i] != null) {
            Image image = new Image();
            faqCategory.setImage(image);
            String filename = (String)row[i];
            image.setFilename(filename);
        }
        ++i;
        if (completeFetch) {
            // empty if block
        }
        return faq;
    }
}

