/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.insuranceclaim.controller;

import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.common.util.FileUtils;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.common.controller.AbstractLazyController;
import org.giavacms.insuranceclaim.model.InsuranceClaimCategory;
import org.giavacms.insuranceclaim.producer.InsuranceClaimProducer;
import org.giavacms.insuranceclaim.repository.InsuranceClaimCategoryRepository;

@Named
@SessionScoped
public class InsuranceClaimCategoryController
extends AbstractLazyController<InsuranceClaimCategory> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    public static String VIEW = "/private/insuranceclaim/category/view.xhtml";
    @ListPage
    public static String LIST = "/private/insuranceclaim/category/list.xhtml";
    @EditPage
    public static String EDIT = "/private/insuranceclaim/category/edit.xhtml";
    public static String EDIT_IMAGE = "/private/insuranceclaim/category/edit-image.xhtml";
    @Inject
    @OwnRepository(value=InsuranceClaimCategoryRepository.class)
    InsuranceClaimCategoryRepository insuranceClaimCategoryRepository;
    @Inject
    InsuranceClaimProducer insuranceClaimProducer;

    public void initController() {
    }

    public String update() {
        this.saveImage();
        return super.update();
    }

    public String updateAndModifyImage() {
        this.update();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String save() {
        this.saveImage();
        this.insuranceClaimProducer.reset();
        return super.save();
    }

    public String saveAndModifyImage() {
        this.saveImage();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        this.insuranceClaimProducer.reset();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String delete() {
        super.delete();
        this.insuranceClaimProducer.reset();
        return this.listPage();
    }

    public String deleteImg() {
        ((InsuranceClaimCategory)this.getElement()).setImage(null);
        this.insuranceClaimCategoryRepository.update(this.getElement());
        return this.listPage();
    }

    public String modImage() {
        super.modElement();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String modImageCurrent() {
        super.modCurrent();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    private void saveImage() {
        if (((InsuranceClaimCategory)this.getElement()).getNewImage().getUploadedData() != null && ((InsuranceClaimCategory)this.getElement()).getNewImage().getUploadedData().getContents() != null && ((InsuranceClaimCategory)this.getElement()).getNewImage().getUploadedData().getFileName() != null && !((InsuranceClaimCategory)this.getElement()).getNewImage().getUploadedData().getFileName().isEmpty()) {
            this.logger.info((Object)("carico nuova immagine: " + ((InsuranceClaimCategory)this.getElement()).getNewImage().getUploadedData().getFileName()));
            Image img = new Image();
            img.setData(((InsuranceClaimCategory)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setType(((InsuranceClaimCategory)this.getElement()).getNewImage().getUploadedData().getContentType());
            String filename = FileUtils.createImage_((String)"img", (String)((InsuranceClaimCategory)this.getElement()).getNewImage().getUploadedData().getFileName(), (byte[])((InsuranceClaimCategory)this.getElement()).getNewImage().getUploadedData().getContents());
            img.setFilename(filename);
            ((InsuranceClaimCategory)this.getElement()).setImage(img);
            ((InsuranceClaimCategory)this.getElement()).setNewImage(null);
        } else {
            this.logger.info((Object)"non c'e' nuova immagine");
        }
    }

    public Object getId(InsuranceClaimCategory t) {
        return t.getId();
    }

    public String reset() {
        this.insuranceClaimProducer.reset();
        return super.reset();
    }
}

