/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.insuranceclaim.controller.request;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.controller.AbstractRequestController;
import org.giavacms.common.model.Search;
import org.giavacms.insuranceclaim.model.InsuranceClaimCategory;
import org.giavacms.insuranceclaim.repository.InsuranceClaimCategoryRepository;

@Named
@RequestScoped
public class InsuranceClaimCategoryRequestController
extends AbstractRequestController<InsuranceClaimCategory>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TIPOLOGIA = "tipologia";
    public static final String CATEGORIA = "categoria";
    public static final String SEARCH = "q";
    public static final String[] PARAM_NAMES = new String[]{"tipologia", "q"};
    public static final String ID_PARAM = "id";
    public static final String CURRENT_PAGE_PARAM = "start";
    @Inject
    @OwnRepository(value=InsuranceClaimCategoryRepository.class)
    InsuranceClaimCategoryRepository insuranceClaimCategoryRepository;

    protected void init() {
        super.init();
    }

    public List<InsuranceClaimCategory> getCategorie(String tipologia) {
        Search r = new Search(InsuranceClaimCategory.class);
        ((InsuranceClaimCategory)r.getObj()).getInsuranceClaimTypology().setName(tipologia);
        return this.insuranceClaimCategoryRepository.getList(r, 0, 0);
    }

    public List<InsuranceClaimCategory> loadPage(int startRow, int pageSize) {
        Search r = new Search(InsuranceClaimCategory.class);
        ((InsuranceClaimCategory)r.getObj()).setName((String)this.getParams().get(SEARCH));
        ((InsuranceClaimCategory)r.getObj()).getInsuranceClaimTypology().setName((String)this.getParams().get(TIPOLOGIA));
        return this.insuranceClaimCategoryRepository.getList(r, startRow, pageSize);
    }

    public int totalSize() {
        Search r = new Search(InsuranceClaimCategory.class);
        ((InsuranceClaimCategory)r.getObj()).getInsuranceClaimTypology().setName((String)this.getParams().get(TIPOLOGIA));
        ((InsuranceClaimCategory)r.getObj()).setName((String)this.getParams().get(SEARCH));
        return this.insuranceClaimCategoryRepository.getListSize(r);
    }

    public String[] getParamNames() {
        return PARAM_NAMES;
    }

    public String getIdParam() {
        return ID_PARAM;
    }

    public String getCurrentPageParam() {
        return CURRENT_PAGE_PARAM;
    }

    public boolean isScheda() {
        return this.getElement() != null && ((InsuranceClaimCategory)this.getElement()).getId() != null;
    }

    public String viewElement(Long id) {
        this.setElement(this.insuranceClaimCategoryRepository.fetch(id));
        return this.viewPage();
    }

    public InsuranceClaimCategory getElementByName() {
        if (this.getParams().get(CATEGORIA) != null && !((String)this.getParams().get(CATEGORIA)).isEmpty()) {
            this.logger.info((Object)("CATEGORIA: " + (String)this.getParams().get(CATEGORIA)));
            return this.insuranceClaimCategoryRepository.findByName((String)this.getParams().get(CATEGORIA));
        }
        return new InsuranceClaimCategory();
    }

    public List<InsuranceClaimCategory> getAllCategories(String tipologia) {
        return this.insuranceClaimCategoryRepository.fetchAll(tipologia);
    }
}

