/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.insuranceclaim.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.giavacms.insuranceclaim.model.InsuranceClaimCategory;

@Entity
@Table(name="ICTypology")
public class InsuranceClaimTypology
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String description;
    private List<InsuranceClaimCategory> insuranceClaimCategories;
    private boolean active = true;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Lob
    @Column(length=102400)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @OneToMany(mappedBy="insuranceClaimTypology", fetch=FetchType.LAZY)
    @OrderBy(value="name")
    public List<InsuranceClaimCategory> getInsuranceClaimCategories() {
        if (this.insuranceClaimCategories == null) {
            this.insuranceClaimCategories = new ArrayList<InsuranceClaimCategory>();
        }
        return this.insuranceClaimCategories;
    }

    public void setInsuranceClaimCategories(List<InsuranceClaimCategory> insuranceClaimCategories) {
        this.insuranceClaimCategories = insuranceClaimCategories;
    }

    public void addInsuranceClaimCategory(InsuranceClaimCategory insuranceClaimCategory) {
        this.getInsuranceClaimCategories().add(insuranceClaimCategory);
    }

    public String toString() {
        return "InsuranceClaimCategory [id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", active=" + this.active + "]";
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

