/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.insuranceclaim.producer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Produces;
import javax.faces.model.SelectItem;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.Repository;
import org.giavacms.common.util.JSFUtils;
import org.giavacms.insuranceclaim.model.InsuranceClaimCategory;
import org.giavacms.insuranceclaim.model.InsuranceClaimTypology;
import org.giavacms.insuranceclaim.repository.InsuranceClaimCategoryRepository;
import org.giavacms.insuranceclaim.repository.InsuranceClaimTypologyRepository;
import org.jboss.logging.Logger;

@SessionScoped
@Named
public class InsuranceClaimProducer
implements Serializable {
    Logger logger = Logger.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    @Inject
    private InsuranceClaimCategoryRepository insuranceClaimCategoryRepository;
    @Inject
    private InsuranceClaimTypologyRepository insuranceClaimTypologyRepository;
    private Map<Class, SelectItem[]> items = null;

    @Produces
    @Named
    public SelectItem[] getInsuranceClaimCategoryItems() {
        if (this.items.get(InsuranceClaimCategory.class) == null) {
            ArrayList<SelectItem> valori = new ArrayList<SelectItem>();
            valori.add(new SelectItem(null, "seleziona categoria..."));
            for (InsuranceClaimCategory t : this.insuranceClaimCategoryRepository.getList(new Search(InsuranceClaimCategory.class), 0, 0)) {
                valori.add(new SelectItem((Object)t.getId(), t.getInsuranceClaimTypology().getName() + " - " + t.getName()));
            }
            this.items.put(InsuranceClaimCategory.class, valori.toArray(new SelectItem[0]));
        }
        return this.items.get(InsuranceClaimCategory.class);
    }

    @Produces
    @Named
    public SelectItem[] getInsuranceClaimTypologyItems() {
        if (this.items.get(InsuranceClaimTypology.class) == null) {
            this.items.put(InsuranceClaimTypology.class, JSFUtils.setupItems((Search)new Search(InsuranceClaimTypology.class), (Repository)this.insuranceClaimTypologyRepository, (String)"id", (String)"name", (String)"nessuna tipologia", (String)"seleziona tipologia..."));
        }
        return this.items.get(InsuranceClaimTypology.class);
    }

    public void resetItemsForClass(Class clazz) {
        if (this.items.containsKey(clazz)) {
            this.items.remove(clazz);
        }
    }

    @PostConstruct
    public void reset() {
        this.items = new HashMap<Class, SelectItem[]>();
    }
}

