/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.insuranceclaim.controller;

import java.io.IOException;
import java.util.ArrayList;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.common.util.ImageUtils;
import org.giavacms.base.common.util.ResourceUtils;
import org.giavacms.base.model.attachment.Document;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.base.model.enums.ResourceType;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.common.controller.AbstractLazyController;
import org.giavacms.insuranceclaim.model.InsuranceClaimConfiguration;
import org.giavacms.insuranceclaim.model.InsuranceClaimProduct;
import org.giavacms.insuranceclaim.repository.InsuranceClaimConfigurationRepository;
import org.giavacms.insuranceclaim.repository.InsuranceClaimProductRepository;
import org.primefaces.event.FileUploadEvent;

@Named
@SessionScoped
public class InsuranceClaimProductController
extends AbstractLazyController<InsuranceClaimProduct> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    public static String VIEW = "/private/insuranceclaim/view.xhtml";
    @ListPage
    public static String LIST = "/private/insuranceclaim/list.xhtml";
    @EditPage
    public static String NEW_OR_EDIT = "/private/insuranceclaim/edit.xhtml";
    public static String EDIT_DOCS = "/private/insuranceclaim/edit-documents.xhtml";
    @Inject
    @OwnRepository(value=InsuranceClaimProductRepository.class)
    InsuranceClaimProductRepository insuranceClaimProductRepository;
    @Inject
    InsuranceClaimConfigurationRepository insuranceClaimConfigurationRepository;

    public String modDocumentsCurrent() {
        super.modCurrent();
        return EDIT_DOCS + "?faces-redirect=true";
    }

    public String modDocuments() {
        super.modElement();
        return EDIT_DOCS + "?faces-redirect=true";
    }

    public void handleUpload(FileUploadEvent event) {
        this.logger.info((Object)("Uploaded: " + event.getFile().getFileName() + " - " + event.getFile().getContentType() + "- " + event.getFile().getSize()));
        String type = ResourceUtils.getType((String)event.getFile().getFileName());
        if (ResourceType.IMAGE.name().equals(type)) {
            this.handleImgUpload(event);
        } else {
            this.handleFileUpload(event);
        }
    }

    public void handleFileUpload(FileUploadEvent event) {
        Document doc = new Document();
        doc.setUploadedData(event.getFile());
        doc.setData(event.getFile().getContents());
        doc.setType(event.getFile().getContentType());
        String filename = ResourceUtils.createFile_((String)"docs", (String)event.getFile().getFileName(), (byte[])event.getFile().getContents());
        doc.setFilename(filename);
        ((InsuranceClaimProduct)this.getElement()).getDocuments().add(doc);
    }

    public void handleImgUpload(FileUploadEvent event) {
        try {
            String type = event.getFile().getFileName().substring(event.getFile().getFileName().lastIndexOf(".") + 1);
            InsuranceClaimConfiguration insuranceClamsConfiguration = this.insuranceClaimConfigurationRepository.load();
            byte[] imgRes = insuranceClamsConfiguration.isResize() ? ImageUtils.resizeImage((byte[])event.getFile().getContents(), (int)insuranceClamsConfiguration.getMaxWidthOrHeight(), (String)type) : event.getFile().getContents();
            Image img = new Image();
            img.setUploadedData(event.getFile());
            img.setData(imgRes);
            img.setType(event.getFile().getContentType());
            String filename = ResourceUtils.createImage_((String)"img", (String)event.getFile().getFileName(), (byte[])imgRes);
            img.setFilename(filename);
            ((InsuranceClaimProduct)this.getElement()).getImages().add(img);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeDocument(Long id) {
        if (id != null && this.getElement() != null && ((InsuranceClaimProduct)this.getElement()).getDocuments() != null && ((InsuranceClaimProduct)this.getElement()).getDocuments().size() > 0) {
            ArrayList<Document> docsNew = new ArrayList<Document>();
            for (Document doc : ((InsuranceClaimProduct)this.getElement()).getDocuments()) {
                if (doc.getId() == null || doc.getId().equals(id)) continue;
                docsNew.add(doc);
            }
            ((InsuranceClaimProduct)this.getElement()).setDocuments(docsNew);
            this.insuranceClaimProductRepository.update(this.getElement());
        } else {
            this.logger.info((Object)("removeImage: non posso rimuovere id:" + id));
        }
    }

    public void removeImage(Long id) {
        if (id != null && this.getElement() != null && ((InsuranceClaimProduct)this.getElement()).getImages() != null && ((InsuranceClaimProduct)this.getElement()).getImages().size() > 0) {
            ArrayList<Image> imagesNew = new ArrayList<Image>();
            for (Image img : ((InsuranceClaimProduct)this.getElement()).getImages()) {
                if (img.getId() == null || img.getId().equals(id)) continue;
                imagesNew.add(img);
            }
            ((InsuranceClaimProduct)this.getElement()).setImages(imagesNew);
            this.insuranceClaimProductRepository.update(this.getElement());
        } else {
            this.logger.info((Object)("removeImage: non posso rimuovere id:" + id));
        }
    }

    public String save() {
        super.save();
        return super.viewPage();
    }

    public String saveAndmodDocuments() {
        this.save();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_DOCS + "?faces-redirect=true";
    }

    public String delete() {
        return super.delete();
    }

    public String update() {
        super.update();
        return super.viewPage();
    }

    public String updateAndmodDocuments() {
        this.update();
        this.setEditMode(true);
        this.setReadOnlyMode(false);
        return EDIT_DOCS + "?faces-redirect=true";
    }
}

