/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.insuranceclaim.controller.request;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.common.annotation.HttpParam;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.controller.AbstractRequestController;
import org.giavacms.common.model.Search;
import org.giavacms.insuranceclaim.model.InsuranceClaimCategory;
import org.giavacms.insuranceclaim.repository.InsuranceClaimCategoryRepository;

@Named
@RequestScoped
public class InsuranceClaimCategoryRequestController
extends AbstractRequestController<InsuranceClaimCategory>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @HttpParam(value="tipologia")
    @Inject
    String typology;
    @HttpParam(value="categoria")
    @Inject
    String category;
    @HttpParam(value="q")
    @Inject
    String search;
    @HttpParam(value="id")
    @Inject
    String id;
    @Inject
    @HttpParam(value="start")
    String start;
    public static final String ID_PARAM = "id";
    public static final String CURRENT_PAGE_PARAM = "start";
    @Inject
    @OwnRepository(value=InsuranceClaimCategoryRepository.class)
    InsuranceClaimCategoryRepository insuranceClaimCategoryRepository;

    public List<InsuranceClaimCategory> getCategorie(String tipologia) {
        Search r = new Search(InsuranceClaimCategory.class);
        ((InsuranceClaimCategory)r.getObj()).getInsuranceClaimTypology().setName(tipologia);
        return this.insuranceClaimCategoryRepository.getList(r, 0, 0);
    }

    protected void initSearch() {
        ((InsuranceClaimCategory)this.getSearch().getObj()).setName(this.search);
        ((InsuranceClaimCategory)this.getSearch().getObj()).getInsuranceClaimTypology().setName(this.typology);
        super.initSearch();
    }

    public String getIdParam() {
        return ID_PARAM;
    }

    public String getCurrentPageParam() {
        return CURRENT_PAGE_PARAM;
    }

    public boolean isScheda() {
        return this.getElement() != null && ((InsuranceClaimCategory)this.getElement()).getId() != null;
    }

    public InsuranceClaimCategory getElementByName() {
        if (this.category != null && !this.category.isEmpty()) {
            this.logger.info((Object)("CATEGORIA: " + this.category));
            return this.insuranceClaimCategoryRepository.findByName(this.category);
        }
        return new InsuranceClaimCategory();
    }

    public List<InsuranceClaimCategory> getAllCategories(String tipologia) {
        return this.insuranceClaimCategoryRepository.fetchAll(tipologia);
    }
}

