/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.insuranceclaim.repository;

import java.util.List;
import java.util.Map;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.AbstractRepository;
import org.giavacms.insuranceclaim.model.InsuranceClaimCategory;
import org.giavacms.insuranceclaim.model.InsuranceClaimProduct;

@Named
@Stateless
@LocalBean
public class InsuranceClaimCategoryRepository
extends AbstractRepository<InsuranceClaimCategory> {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    EntityManager em;

    protected EntityManager getEm() {
        return this.em;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    protected String getDefaultOrderBy() {
        return "orderNum asc";
    }

    public boolean delete(Object key) {
        try {
            InsuranceClaimCategory insuranceClaimCategory = (InsuranceClaimCategory)this.getEm().find(this.getEntityType(), key);
            if (insuranceClaimCategory != null) {
                insuranceClaimCategory.setActive(false);
                this.getEm().merge((Object)insuranceClaimCategory);
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    protected void applyRestrictions(Search<InsuranceClaimCategory> search, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(alias).append(".active = :active");
        params.put("active", true);
        separator = " and ";
        if (((InsuranceClaimCategory)search.getObj()).getName() != null && !((InsuranceClaimCategory)search.getObj()).getName().isEmpty()) {
            sb.append(separator).append(" upper(").append(alias).append(".name ) like :NAME ");
            params.put("NAME", this.likeParam(((InsuranceClaimCategory)search.getObj()).getName().toUpperCase()));
        }
        if (((InsuranceClaimCategory)search.getObj()).getInsuranceClaimTypology() != null && ((InsuranceClaimCategory)search.getObj()).getInsuranceClaimTypology().getName() != null && !((InsuranceClaimCategory)search.getObj()).getInsuranceClaimTypology().getName().isEmpty()) {
            sb.append(separator).append(" upper(").append(alias).append(".insuranceClaimTypology.name ) like :NAME_TIP ");
            params.put("NAME_TIP", this.likeParam(((InsuranceClaimCategory)search.getObj()).getInsuranceClaimTypology().getName().toUpperCase()));
        }
    }

    public InsuranceClaimCategory findByName(String name) {
        Search r = new Search(InsuranceClaimCategory.class);
        ((InsuranceClaimCategory)r.getObj()).setName(name);
        List list = this.getList(r, 0, 0);
        if (list != null && list.size() > 0) {
            logger.info((Object)("ci sono con name: " + name));
            return (InsuranceClaimCategory)list.get(0);
        }
        logger.info((Object)("NON ci sono con name: " + name));
        return null;
    }

    public List<InsuranceClaimCategory> fetchAll(String tipologia) {
        Search r = new Search(InsuranceClaimCategory.class);
        ((InsuranceClaimCategory)r.getObj()).getInsuranceClaimTypology().setName(tipologia);
        ((InsuranceClaimCategory)r.getObj()).getInsuranceClaimTypology().setName(tipologia);
        List list = this.getList(r, 0, 0);
        for (InsuranceClaimCategory insuranceClaimCategory : list) {
            for (InsuranceClaimProduct prod : insuranceClaimCategory.getInsuranceClaimProducts()) {
                prod.getName();
                prod.getDescription();
            }
        }
        return list;
    }

    public InsuranceClaimCategory fetch(Object key) {
        try {
            Long id;
            if (key instanceof String) {
                id = Long.valueOf((String)key);
            } else if (key instanceof Long) {
                id = (Long)key;
            } else {
                throw new Exception("key type is not correct!!");
            }
            InsuranceClaimCategory insuranceClaimCategory = (InsuranceClaimCategory)super.fetch((Object)id);
            return insuranceClaimCategory;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

