/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.paypalweb.controller;

import java.util.Date;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.common.controller.AbstractLazyController;
import org.giavacms.paypalweb.model.ShoppingCart;
import org.giavacms.paypalweb.model.enums.PaypalStatus;
import org.giavacms.paypalweb.repository.ShoppingCartRepository;
import org.giavacms.paypalweb.service.NotificationService;

@Named
@SessionScoped
public class ShoppingCartController
extends AbstractLazyController<ShoppingCart> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    public static String VIEW_PAGE = "/private/paypalweb/view.xhtml";
    @ListPage
    public static String LIST_PAGE = "/private/paypalweb/list.xhtml";
    @EditPage
    public static String EDIT_PAGE = "/private/paypalweb/edit.xhtml";
    @Inject
    @OwnRepository(value=ShoppingCartRepository.class)
    ShoppingCartRepository shoppingCartRepository;
    @Inject
    NotificationService notificationService;

    public String viewElement() {
        String vieL = super.viewElement();
        this.logger.info(this.getElement());
        return vieL;
    }

    public String sent() {
        ((ShoppingCart)this.getElement()).setSentDate(new Date());
        ((ShoppingCart)this.getElement()).setPaypalStatus(PaypalStatus.Sent);
        this.shoppingCartRepository.update(this.getElement());
        this.notificationService.notifySent((ShoppingCart)this.getElement());
        return this.viewCurrent();
    }

    public String refund() {
        ((ShoppingCart)this.getElement()).setRefundedDate(new Date());
        ((ShoppingCart)this.getElement()).setPaypalStatus(PaypalStatus.Refunded);
        this.shoppingCartRepository.update(this.getElement());
        this.notificationService.notifyRefunded((ShoppingCart)this.getElement());
        return this.viewCurrent();
    }

    public String undo() {
        ((ShoppingCart)this.getElement()).setUndoDate(new Date());
        ((ShoppingCart)this.getElement()).setPaypalStatus(PaypalStatus.Undo);
        this.shoppingCartRepository.update(this.getElement());
        return this.viewCurrent();
    }

    public String delete() {
        ((ShoppingCart)this.getElement()).setActive(false);
        this.shoppingCartRepository.update(this.getElement());
        return this.listPage();
    }
}

