/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.paypalweb.controller.request;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.giavacms.paypalweb.controller.request.PaypalConfigurationRequestController;
import org.giavacms.paypalweb.model.IpnContent;
import org.giavacms.paypalweb.model.ShoppingCart;
import org.giavacms.paypalweb.model.enums.PaypalStatus;
import org.giavacms.paypalweb.repository.IpnContentRepository;
import org.giavacms.paypalweb.repository.ShoppingCartRepository;
import org.giavacms.paypalweb.service.NotificationService;
import org.giavacms.paypalweb.util.IpnUtils;
import org.jboss.logging.Logger;

@RequestScoped
@Named
public class IpnRequestController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger(this.getClass());
    @Inject
    PaypalConfigurationRequestController paypalProducer;
    @Inject
    ShoppingCartRepository shoppingCartRepository;
    @Inject
    IpnContentRepository ipnContentRepository;
    @Inject
    NotificationService notificationService;
    boolean completed = false;

    public void handleIpn(HttpServletRequest request) {
        this.logger.info((Object)"inside IpnController.handleIpn");
        try {
            String res = IpnUtils.postToPaypal(request, this.paypalProducer.getPaypalConfiguration().getServiceUrl());
            this.logger.info((Object)("IpnRequestController.handleIpn - postToPaypal reponse: " + res));
            IpnContent ipnContent = IpnUtils.fromRequest(request, res);
            this.ipnContentRepository.persist(ipnContent);
            this.logger.info((Object)ipnContent.getId());
            if (res.equals("VERIFIED")) {
                PaypalStatus paypalStatus;
                this.logger.info((Object)"Paypal IPN Information: VERIFIED");
                this.completed = true;
                ShoppingCart shoppingCart = (ShoppingCart)this.shoppingCartRepository.find(Long.parseLong(ipnContent.getCustom()));
                if (shoppingCart == null) {
                    this.completed = false;
                    this.logger.info((Object)("doesn't exist shoppingCart with custom id {" + ipnContent.getCustom() + "}"));
                }
                if ((paypalStatus = PaypalStatus.get(ipnContent.getPaymentStatus())) == null) {
                    this.completed = false;
                    this.logger.info((Object)"payment_status IS NULLL ");
                } else {
                    shoppingCart.setPaypalStatus(paypalStatus);
                    this.logger.info((Object)("payment_status IS " + paypalStatus.name()));
                }
                IpnContent oldIpnInfo = this.ipnContentRepository.findByTxnId(ipnContent.getTxnId(), ipnContent.getId());
                if (oldIpnInfo != null) {
                    this.completed = false;
                    this.logger.info((Object)("txn_id is already processed {old ipn_info " + oldIpnInfo.getId()));
                }
                if (!ipnContent.getReceiverEmail().equalsIgnoreCase(this.paypalProducer.getPaypalConfiguration().getEmail())) {
                    this.completed = false;
                    this.logger.info((Object)("receiver_email " + ipnContent.getReceiverEmail() + " does not match with configured ipn email " + this.paypalProducer.getPaypalConfiguration().getEmail()));
                }
                if ((paypalStatus.equals((Object)PaypalStatus.Completed) || paypalStatus.equals((Object)PaypalStatus.Pending)) && Double.parseDouble(ipnContent.getPaymentAmount()) != shoppingCart.getTotalWithSipping()) {
                    this.completed = false;
                    this.logger.info((Object)("payment amount mc_gross " + ipnContent.getPaymentAmount() + " does not match with configured ipn amount " + shoppingCart.getTotalWithSipping()));
                }
                if (paypalStatus.equals((Object)PaypalStatus.Refunded) && Double.parseDouble(ipnContent.getPaymentAmount()) != -shoppingCart.getTotalWithSipping()) {
                    this.completed = false;
                    this.logger.info((Object)("payment amount mc_gross " + ipnContent.getPaymentAmount() + " does not match with configured ipn amount " + shoppingCart.getTotalWithSipping()));
                }
                if (!ipnContent.getPaymentCurrency().equalsIgnoreCase(shoppingCart.getCurrency())) {
                    this.completed = false;
                    this.logger.info((Object)("payment currency mc_currency " + ipnContent.getPaymentCurrency() + " does not match with configured ipn currency " + shoppingCart.getCurrency()));
                }
                if (this.completed) {
                    switch (paypalStatus) {
                        case Completed: {
                            this.logger.info((Object)"payment_status IS COMPLETED");
                            this.logger.info((Object)"completed");
                            this.logger.info((Object)"update shopping cart: confirmed");
                            shoppingCart.setCompletedDate(new Date());
                            shoppingCart.setLogId(ipnContent.getId());
                            this.shoppingCartRepository.update(shoppingCart);
                            this.notificationService.notifyCompleted(shoppingCart);
                            break;
                        }
                        case Pending: {
                            this.logger.info((Object)"payment_status IS PENDING");
                            if (!this.paypalProducer.getPaypalConfiguration().isLogOnly()) break;
                            this.logger.info((Object)"IN TEST - payment_status IS COMPLETED");
                            this.logger.info((Object)"completed");
                            this.logger.info((Object)"update shopping cart: confirmed");
                            shoppingCart.setCompletedDate(new Date());
                            shoppingCart.setLogId(ipnContent.getId());
                            this.shoppingCartRepository.update(shoppingCart);
                            this.notificationService.notifyCompleted(shoppingCart);
                            break;
                        }
                        case Refunded: {
                            this.logger.info((Object)"payment_status IS REFUNDED");
                            shoppingCart.setRefundedDate(new Date());
                            this.shoppingCartRepository.update(shoppingCart);
                            this.notificationService.notifyRefunded(shoppingCart);
                            break;
                        }
                        case Canceled_Reversal: 
                        case Created: 
                        case Denied: 
                        case Expired: 
                        case Failed: 
                        case Reversed: 
                        case Processed: 
                        case Voided: {
                            this.logger.info((Object)("payment_status IS " + paypalStatus.name()));
                            shoppingCart.setNotCompletedDate(new Date());
                            this.shoppingCartRepository.update(shoppingCart);
                        }
                    }
                } else {
                    this.logger.info((Object)"not completed");
                    this.logger.info((Object)"update shopping cart: not confirmed");
                    shoppingCart.setNotCompletedDate(new Date());
                    this.shoppingCartRepository.update(shoppingCart);
                }
            } else {
                this.logger.info((Object)("Invalid response {" + res + "} expecting {VERIFIED}"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

