/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.paypalweb.controller.request;

import java.io.IOException;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.common.util.EmailUtils;
import org.giavacms.common.annotation.HttpParam;
import org.giavacms.common.util.MessageUtils;
import org.giavacms.paypalweb.controller.request.PaypalConfigurationRequestController;
import org.giavacms.paypalweb.controller.session.ShoppingCartSessionController;
import org.giavacms.paypalweb.model.BillingAddress;
import org.giavacms.paypalweb.model.ShippingAddress;
import org.giavacms.paypalweb.model.pojo.CountryCode;
import org.giavacms.paypalweb.util.CountryCodeUtils;
import org.jboss.logging.Logger;

@Named
@RequestScoped
public class PayerInfoRequestController {
    @Inject
    @HttpParam
    String billingFirstName;
    @Inject
    @HttpParam
    String billingLastName;
    @Inject
    @HttpParam
    String billingCompany;
    @Inject
    @HttpParam
    String billingVatCode;
    @Inject
    @HttpParam
    String billingLine1;
    @Inject
    @HttpParam
    String billingLine2;
    @Inject
    @HttpParam
    String billingCity;
    @Inject
    @HttpParam
    String billingCountryCode;
    @Inject
    @HttpParam
    String billingZip;
    @Inject
    @HttpParam
    String billingState;
    @Inject
    @HttpParam
    String billingPhone;
    @Inject
    @HttpParam
    String billingEmail;
    @Inject
    @HttpParam
    String notes;
    @Inject
    @HttpParam
    String shippingFirstName;
    @Inject
    @HttpParam
    String shippingLastName;
    @Inject
    @HttpParam
    String shippingLine1;
    @Inject
    @HttpParam
    String shippingLine2;
    @Inject
    @HttpParam
    String shippingCity;
    @Inject
    @HttpParam
    String shippingCountryCode;
    @Inject
    @HttpParam
    String shippingZip;
    @Inject
    @HttpParam
    String shippingState;
    Logger logger = Logger.getLogger((String)this.getClass().getName());
    @Inject
    PaypalConfigurationRequestController paypalConfigurationRequestController;
    @Inject
    ShoppingCartSessionController shoppingCartSessionController;

    public String addPayer() {
        ShippingAddress shippingAddress;
        StringBuffer errors = new StringBuffer();
        String sep = " ";
        if (!(this.billingFirstName == null || this.billingFirstName.trim().isEmpty() || this.billingLastName == null || this.billingLastName.trim().isEmpty() || this.billingCompany == null || this.billingCompany.trim().isEmpty() || this.billingLine1 == null || this.billingLine1.trim().isEmpty() || this.billingCity == null || this.billingCity.trim().isEmpty() || this.billingCountryCode == null || this.billingCountryCode.trim().isEmpty() || this.billingZip == null || this.billingZip.trim().isEmpty() || this.billingState == null || this.billingState.trim().isEmpty() || this.billingPhone == null || this.billingPhone.trim().isEmpty() || this.billingEmail == null || this.billingEmail.trim().isEmpty() || !EmailUtils.isValidEmailAddress((String)this.billingEmail.trim()))) {
            this.logger.info((Object)"billing address OK");
        } else {
            if (this.billingFirstName == null || this.billingFirstName.trim().isEmpty()) {
                errors.append(sep + "manca il nome (fatturazione)");
                sep = " - ";
            }
            if (this.billingLastName == null || this.billingLastName.trim().isEmpty()) {
                errors.append(sep + "manca il cognome (fatturazione)");
                sep = " - ";
            }
            if (this.billingCompany != null && this.billingCompany.trim().equals("true") && (this.billingVatCode == null || this.billingVatCode.trim().isEmpty())) {
                errors.append(sep + "manca la partita iva (fatturazione)");
                sep = " - ";
            }
            if (this.billingLine1 == null || this.billingLine1.trim().isEmpty()) {
                errors.append(sep + "manca l'indirizzo (fatturazione)");
                sep = " - ";
            }
            if (this.billingCity == null || this.billingCity.trim().isEmpty()) {
                errors.append(sep + "manca la citta' (fatturazione)");
                sep = " - ";
            }
            if (this.billingCountryCode == null || this.billingCountryCode.trim().isEmpty()) {
                errors.append(sep + "manca lo stato (fatturazione)");
                sep = " - ";
            }
            if (this.billingZip == null || this.billingZip.trim().isEmpty()) {
                errors.append(sep + "manca il codice postale (fatturazione)");
                sep = " - ";
            }
            if (this.billingState == null || this.billingState.trim().isEmpty()) {
                errors.append(sep + "manca la provincia (fatturazione)");
                sep = " - ";
            }
            if (this.billingPhone == null || this.billingPhone.trim().isEmpty()) {
                errors.append(sep + "manca il telefono (fatturazione)");
                sep = " - ";
            }
            if (this.billingEmail == null || this.billingEmail.trim().isEmpty()) {
                errors.append(sep + "manca la mail (fatturazione)");
                sep = " - ";
            } else if (!EmailUtils.isValidEmailAddress((String)this.billingEmail)) {
                errors.append(sep + "la mail inserita non e' valida (fatturazione)");
                sep = " - ";
            }
        }
        if (this.notes != null && !this.notes.trim().isEmpty()) {
            this.shoppingCartSessionController.setNotes(this.notes);
        }
        BillingAddress billingAddress = new BillingAddress(this.billingFirstName, this.billingLastName, this.billingCompany, this.billingVatCode, this.billingLine1, this.billingLine2, this.billingCity, this.billingCountryCode, this.billingZip, this.billingState, this.billingPhone, this.billingEmail);
        this.shoppingCartSessionController.addBillingAddress(billingAddress);
        if (!this.shoppingCartSessionController.isOneAddress()) {
            if (!(this.shippingFirstName == null || this.shippingFirstName.trim().isEmpty() || this.shippingLastName == null || this.shippingLastName.trim().isEmpty() || this.shippingLine1 == null || this.shippingLine1.trim().isEmpty() || this.shippingCity == null || this.shippingCity.trim().isEmpty() || this.shippingCountryCode == null || this.shippingCountryCode.trim().isEmpty() || this.shippingZip == null || this.shippingZip.trim().isEmpty() || this.shippingState == null || this.shippingState.trim().isEmpty())) {
                this.logger.info((Object)"shipping address OK");
            } else {
                if (this.shippingFirstName == null || this.shippingFirstName.trim().isEmpty()) {
                    errors.append(sep + "manca il nome (consegna)");
                    sep = " - ";
                }
                if (this.shippingLastName == null || this.shippingLastName.trim().isEmpty()) {
                    errors.append("; manca il cognome (consegna)");
                    sep = " - ";
                }
                if (this.shippingLine1 == null || this.shippingLine1.trim().isEmpty()) {
                    errors.append("manca la l'indirizzo (consegna)");
                    sep = " - ";
                }
                if (this.shippingCity == null || this.shippingCity.trim().isEmpty()) {
                    errors.append(sep + "manca la citta' (consegna)");
                    sep = " - ";
                }
                if (this.shippingCountryCode == null || this.shippingCountryCode.trim().isEmpty()) {
                    errors.append(sep + "manca lo stato (consegna)");
                    sep = " - ";
                }
                if (this.shippingZip == null || this.shippingZip.trim().isEmpty()) {
                    errors.append(sep + "manca il codice postale (consegna)");
                    sep = " - ";
                }
                if (this.shippingState == null || this.shippingState.trim().isEmpty()) {
                    errors.append(sep + "manca la provincia (consegna)");
                    sep = " - ";
                }
            }
            shippingAddress = new ShippingAddress(this.shippingFirstName, this.shippingLastName, this.shippingLine1, this.shippingLine2, this.shippingCity, this.shippingCountryCode, this.shippingZip, this.shippingState);
            this.shoppingCartSessionController.addShippingAddress(shippingAddress);
        } else {
            shippingAddress = new ShippingAddress(this.billingFirstName, this.billingLastName, this.billingLine1, this.billingLine2, this.billingCity, this.billingCountryCode, this.billingZip, this.billingState);
            this.shoppingCartSessionController.addShippingAddress(shippingAddress);
        }
        if (errors.length() > 0) {
            this.logger.info((Object)errors.toString());
            MessageUtils.addFacesMessage((String)errors.toString().substring(1), (String)errors.toString().substring(1));
        } else {
            this.shoppingCartSessionController.save();
            try {
                FacesContext.getCurrentInstance().getExternalContext().redirect(this.paypalConfigurationRequestController.getPaypalConfiguration().getPreviewShoppingCartUrl());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getBillingFirstName() {
        return this.billingFirstName;
    }

    public String getBillingLastName() {
        return this.billingLastName;
    }

    public String getBillingCompany() {
        if (this.billingCompany == null || this.billingCompany.trim().isEmpty()) {
            this.billingCompany = "false";
        }
        return this.billingCompany;
    }

    public String getBillingVatCode() {
        return this.billingVatCode;
    }

    public String getBillingLine1() {
        return this.billingLine1;
    }

    public String getBillingLine2() {
        return this.billingLine2;
    }

    public String getBillingCity() {
        return this.billingCity;
    }

    public String getBillingCountryCode() {
        return this.billingCountryCode;
    }

    public String getBillingZip() {
        return this.billingZip;
    }

    public String getBillingState() {
        return this.billingState;
    }

    public String getBillingPhone() {
        return this.billingPhone;
    }

    public String getBillingEmail() {
        return this.billingEmail;
    }

    public String getShippingFirstName() {
        return this.shippingFirstName;
    }

    public String getShippingLastName() {
        return this.shippingLastName;
    }

    public String getShippingLine1() {
        return this.shippingLine1;
    }

    public String getShippingLine2() {
        return this.shippingLine2;
    }

    public String getShippingCity() {
        return this.shippingCity;
    }

    public String getShippingCountryCode() {
        return this.shippingCountryCode;
    }

    public String getShippingZip() {
        return this.shippingZip;
    }

    public String getShippingState() {
        return this.shippingState;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public PaypalConfigurationRequestController getPaypalConfigurationRequestController() {
        return this.paypalConfigurationRequestController;
    }

    public ShoppingCartSessionController getShoppingCartSessionController() {
        return this.shoppingCartSessionController;
    }

    public List<CountryCode> getCountryCodes() {
        return CountryCodeUtils.getCountryCodes();
    }
}

