/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.paypalweb.controller.request;

import java.io.Serializable;
import java.util.Date;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.paypalweb.controller.request.ShoppingCartRequestController;
import org.giavacms.paypalweb.model.ShoppingCart;
import org.giavacms.paypalweb.model.enums.PaypalStatus;
import org.giavacms.paypalweb.repository.ShoppingCartRepository;
import org.giavacms.paypalweb.service.NotificationService;
import org.giavacms.paypalweb.util.FaceletRenderer;
import org.jboss.logging.Logger;

@Named
@RequestScoped
public class PaymentRequestController
implements Serializable {
    private static final long serialVersionUID = 1L;
    Logger logger = Logger.getLogger((String)this.getClass().getName());
    String paymentId;
    @Inject
    ShoppingCartRepository shoppingCartRepository;
    @Inject
    ShoppingCartRequestController shoppingCartRequestController;
    @Inject
    NotificationService notificationService;

    public void verifyConfirm() {
        if (this.paymentId != null && !this.paymentId.isEmpty()) {
            this.logger.info((Object)("ID to confirm: " + this.paymentId));
            ShoppingCart shoppingCart = (ShoppingCart)this.shoppingCartRepository.find(Long.valueOf(this.paymentId));
            this.logger.info((Object)("SHOPPINGCART " + (shoppingCart.isCompleted() ? "COMPLETO" : " NON COMPLETO")));
            this.logger.info((Object)("IN DATA:" + shoppingCart.getCompletedDate()));
        } else {
            this.logger.info((Object)"verifyConfirm: NO ID!");
        }
    }

    public void verifyExit() {
        if (this.paymentId != null && !this.paymentId.isEmpty()) {
            this.logger.info((Object)("ID TO NOT CONFIRMED: " + this.paymentId));
            ShoppingCart shoppingCart = (ShoppingCart)this.shoppingCartRepository.find(Long.valueOf(this.paymentId));
            if (shoppingCart != null && shoppingCart.getCompletedDate() == null) {
                shoppingCart.setPaypalStatus(PaypalStatus.Undo);
                shoppingCart.setUndoDate(new Date());
                shoppingCart.setPaypalStatus(PaypalStatus.Undo);
                this.shoppingCartRepository.update(shoppingCart);
                this.logger.info((Object)"update shopping cart with confirm=false");
                this.shoppingCartRequestController.reset();
            } else {
                this.logger.info((Object)"NO SHOPPINGCART OR PREVIUOUSLY CONFIRMED!");
            }
        } else {
            this.logger.info((Object)"verifyExit: NO ID!");
        }
    }

    public void test(String path) {
        this.logger.info((Object)FaceletRenderer.renderView(path));
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }
}

