/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.paypalweb.controller.request;

import java.io.Serializable;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.common.annotation.HttpParam;
import org.giavacms.paypalweb.controller.request.NavigationRequestController;
import org.giavacms.paypalweb.controller.session.ShoppingCartSessionController;
import org.giavacms.paypalweb.model.ShoppingCart;
import org.jboss.logging.Logger;

@Named
@RequestScoped
public class ShoppingCartRequestController
implements Serializable {
    Logger logger = Logger.getLogger((String)this.getClass().getName());
    private static final long serialVersionUID = 1L;
    @Inject
    @HttpParam
    String idProduct;
    @Inject
    @HttpParam
    String description;
    @Inject
    @HttpParam
    String price;
    @Inject
    @HttpParam
    String quantity;
    @Inject
    @HttpParam
    String vat;
    @Inject
    @HttpParam
    String image;
    String shopId;
    @Inject
    ShoppingCartSessionController shoppingCartSessionController;
    @Inject
    NavigationRequestController navigationRequestController;

    public void load() {
        if (this.getShopId() != null && !this.getShopId().isEmpty()) {
            boolean load = this.shoppingCartSessionController.load(Long.valueOf(this.getShopId()));
            if (load) {
                this.logger.info((Object)("FOUND ELEMENT WITH ID: " + this.getShopId()));
            } else {
                this.logger.info((Object)("NO ELEMENT WITH ID: " + this.getShopId()));
            }
        } else {
            this.logger.info((Object)"NO ELEMENT WITH ID NULL ");
        }
    }

    public void add() {
        if (this.idProduct == null || this.description == null || this.price == null || this.quantity == null || this.vat == null) {
            return;
        }
        this.shoppingCartSessionController.addProduct(this.vat, this.price, this.idProduct, this.description, Integer.valueOf(this.quantity), this.image);
        this.navigationRequestController.goToShoppingCartUrl();
    }

    public boolean isReady() {
        return this.shoppingCartSessionController.isReady();
    }

    public ShoppingCart getElement() {
        return this.shoppingCartSessionController.getElement();
    }

    public void del(String idProduct) {
        this.shoppingCartSessionController.removeArticle(idProduct);
        this.navigationRequestController.goToShoppingCartUrl();
    }

    public void add(int quantity, String idProduct) {
        this.shoppingCartSessionController.changeArticleQuantity(quantity, idProduct);
        this.navigationRequestController.goToShoppingCartUrl();
    }

    public void inc(String idProduct) {
        this.shoppingCartSessionController.changeArticleQuantity(1, idProduct);
        this.navigationRequestController.goToShoppingCartUrl();
    }

    public void dec(String idProduct) {
        this.shoppingCartSessionController.changeArticleQuantity(-1, idProduct);
        this.navigationRequestController.goToShoppingCartUrl();
    }

    public String getButton() {
        return this.shoppingCartSessionController.getButton();
    }

    public String getLastPage() {
        return this.shoppingCartSessionController.getLastPage();
    }

    public void reset() {
        this.shoppingCartSessionController.resetShoppingCart();
        this.navigationRequestController.goToShoppingCartUrl();
    }

    public void exit() {
        this.shoppingCartSessionController.exit();
        this.navigationRequestController.goToShoppingCartUrl();
    }

    public String getShopId() {
        return this.shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }
}

