/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.paypalweb.controller.session;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.ejb.EJB;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.common.annotation.RequestUri;
import org.giavacms.paypalweb.controller.request.PaypalConfigurationRequestController;
import org.giavacms.paypalweb.model.BillingAddress;
import org.giavacms.paypalweb.model.ShippingAddress;
import org.giavacms.paypalweb.model.ShoppingArticle;
import org.giavacms.paypalweb.model.ShoppingCart;
import org.giavacms.paypalweb.model.enums.PaypalStatus;
import org.giavacms.paypalweb.repository.ShoppingCartRepository;
import org.giavacms.paypalweb.service.PaypalSubmitService;
import org.giavacms.paypalweb.service.ShippingService;
import org.giavacms.paypalweb.util.ButtonUtils;
import org.giavacms.paypalweb.util.RequestUriCleaner;
import org.jboss.logging.Logger;

@Named
@SessionScoped
public class ShoppingCartSessionController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String lastPage;
    private ShoppingCart element;
    Logger logger = Logger.getLogger((String)this.getClass().getName());
    @Inject
    PaypalConfigurationRequestController paypalConfigurationRequestController;
    @Inject
    ShoppingCartRepository shoppingCartRepository;
    @EJB
    ShippingService shippingService;
    @EJB
    PaypalSubmitService paypalSubmitService;
    @Inject
    @RequestUri
    Instance<String> requestUri;
    private boolean oneAddress = true;

    public boolean load(Long id) {
        ShoppingCart shoppingCart = (ShoppingCart)this.shoppingCartRepository.find(id);
        this.setElement(shoppingCart);
        return shoppingCart != null;
    }

    public void addBillingAddress(BillingAddress billingAddress) {
        this.getElement().setBillingAddress(billingAddress);
    }

    public void setNotes(String notes) {
        this.getElement().setNotes(notes);
    }

    public void addShippingAddress(ShippingAddress shippingAddress) {
        this.getElement().setShippingAddress(shippingAddress);
    }

    public boolean isReady() {
        return this.paypalSubmitService.isReady(this.getElement());
    }

    public void save() {
        this.getElement().setPaypalStatus(PaypalStatus.Init);
        this.getElement().setInitDate(new Date());
        double shipping = this.shippingService.calculate(this.getElement());
        this.getElement().setShipping(BigDecimal.valueOf(shipping));
        if (this.getElement().getId() == null) {
            this.shoppingCartRepository.persist(this.getElement());
        } else {
            this.shoppingCartRepository.update(this.getElement());
        }
        this.logger.info((Object)this.getElement().getId());
    }

    public String getButton() {
        return ButtonUtils.generate(this.getElement(), this.paypalConfigurationRequestController.getPaypalConfiguration());
    }

    public void addProduct(String vat, String price, String idProduct, String description, int quantity, String imageUrl) {
        this.getElement().addArticle(new ShoppingArticle(idProduct, description, price == null ? null : new BigDecimal(price), quantity, vat == null ? null : new BigDecimal(vat), imageUrl));
        this.logger.info((Object)("idProduct:" + idProduct + " description:" + description + " price: " + price + " quantity: " + quantity + " vat: " + vat + " imageUrl:" + imageUrl));
        this.updateLastPage();
    }

    public void removeArticle(String idProduct) {
        this.getElement().removeArticle(idProduct);
    }

    public void changeArticleQuantity(int quantity, String idProduct) {
        this.getElement().changeArticleQuantity(idProduct, quantity);
    }

    public void incArticleQuantity(String idProduct) {
        this.changeArticleQuantity(1, idProduct);
    }

    public void decArticleQuantity(String idProduct) {
        this.changeArticleQuantity(-1, idProduct);
    }

    public void resetShoppingCart() {
        this.element = new ShoppingCart(this.paypalConfigurationRequestController.getPaypalConfiguration().getCurrency());
        this.element.getBillingAddress().setCountryCode("IT");
        this.element.getShippingAddress().setCountryCode("IT");
    }

    private void updateLastPage() {
        this.setLastPage(RequestUriCleaner.cleanPage((String)this.requestUri.get()));
    }

    public void reset() {
        this.resetShoppingCart();
    }

    public void exit() {
        if (this.getElement().getId() != null) {
            this.getElement().setPaypalStatus(PaypalStatus.Undo);
            this.getElement().setUndoDate(new Date());
            this.shoppingCartRepository.update(this.getElement());
        }
        this.resetShoppingCart();
    }

    public ShoppingCart getElement() {
        if (this.element == null) {
            this.element = new ShoppingCart();
            this.element.getBillingAddress().setCountryCode("IT");
            this.element.getShippingAddress().setCountryCode("IT");
        }
        return this.element;
    }

    public void setElement(ShoppingCart element) {
        this.element = element;
    }

    public String getLastPage() {
        if (this.lastPage != null && !this.lastPage.isEmpty()) {
            return this.lastPage;
        }
        return "";
    }

    public void setLastPage(String lastPage) {
        this.lastPage = lastPage;
    }

    public boolean isOneAddress() {
        return this.oneAddress;
    }

    public void setOneAddress(boolean oneAddress) {
        this.oneAddress = oneAddress;
    }
}

