/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.paypalweb.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.giavacms.paypalweb.model.ShoppingCart;

@Entity
@Table(name="PPW_ShoppingArticle")
public class ShoppingArticle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    public static final String TABLE_NAME = "PPW_ShoppingArticle";
    private String idProduct;
    private String description;
    private BigDecimal price = BigDecimal.ZERO.setScale(2);
    private int quantity = 0;
    private BigDecimal vat = BigDecimal.ZERO.setScale(2);
    private ShoppingCart shoppingCart;
    private String imageUrl;

    public ShoppingArticle() {
    }

    public ShoppingArticle(String idProduct, String description, BigDecimal price, int quantity, BigDecimal vat, String imageUrl) {
        this.idProduct = idProduct;
        this.description = description;
        this.price = price;
        this.quantity = quantity;
        this.vat = vat;
        this.imageUrl = imageUrl;
    }

    public ShoppingArticle(String idProduct, String description, BigDecimal price, int quantity, BigDecimal vat, String currency, String imageUrl) {
        this.idProduct = idProduct;
        this.description = description;
        this.price = price;
        this.quantity = quantity;
        this.vat = vat;
        this.imageUrl = imageUrl;
    }

    @Transient
    public String getTotal() {
        BigDecimal tot = BigDecimal.ZERO;
        if (this.getQuantity() > 0) {
            if (this.getPrice() != null) {
                tot = tot.add(this.getPrice().setScale(2).multiply(new BigDecimal(this.getQuantity())));
            }
            if (this.getVat() != null) {
                tot = tot.add(this.getVat().setScale(2).multiply(new BigDecimal(this.getQuantity())));
            }
        }
        return tot.toString();
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getIdProduct() {
        return this.idProduct;
    }

    public void setIdProduct(String idProduct) {
        this.idProduct = idProduct;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public void inc(int quantity) {
        this.quantity += quantity;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigDecimal getVat() {
        return this.vat;
    }

    public void setVat(BigDecimal vat) {
        this.vat = vat;
    }

    @ManyToOne
    public ShoppingCart getShoppingCart() {
        return this.shoppingCart;
    }

    public void setShoppingCart(ShoppingCart shoppingCart) {
        this.shoppingCart = shoppingCart;
    }

    public String toString() {
        return "ShoppingArticle [id=" + this.id + ", idProduct=" + this.idProduct + ", description=" + this.description + ", price=" + this.price + ", quantity=" + this.quantity + ", vat=" + this.vat + "]";
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }
}

