/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.paypalweb.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.giavacms.common.util.StringUtils;
import org.giavacms.paypalweb.model.BillingAddress;
import org.giavacms.paypalweb.model.ShippingAddress;
import org.giavacms.paypalweb.model.ShoppingArticle;
import org.giavacms.paypalweb.model.enums.PaypalStatus;

@Entity
@Table(name="PPW_ShoppingCart")
public class ShoppingCart
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TABLE_NAME = "PPW_ShoppingCart";
    private Long id;
    private boolean active = true;
    private Date refundedDate;
    private Date completedDate;
    private Date initDate;
    private Date undoDate;
    private Date sentDate;
    private Date notCompletedDate;
    private BigDecimal partialAmount = BigDecimal.ZERO.setScale(2);
    private BigDecimal partialTax = BigDecimal.ZERO.setScale(2);
    private BigDecimal shipping = BigDecimal.ZERO.setScale(2);
    private String currency;
    private BillingAddress billingAddress;
    private ShippingAddress shippingAddress;
    private List<ShoppingArticle> shoppingArticles;
    private Long logId;
    private String notes;
    private PaypalStatus paypalStatus;

    public ShoppingCart() {
        this.currency = "EUR";
        this.initDate = new Date();
    }

    public ShoppingCart(String currency) {
        this.currency = currency;
        this.initDate = new Date();
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="shoppingCart")
    public List<ShoppingArticle> getShoppingArticles() {
        if (this.shoppingArticles == null) {
            this.shoppingArticles = new ArrayList<ShoppingArticle>();
        }
        return this.shoppingArticles;
    }

    public void setShoppingArticles(List<ShoppingArticle> shoppingArticles) {
        this.shoppingArticles = shoppingArticles;
    }

    public void addArticle(ShoppingArticle article) {
        for (ShoppingArticle shoppingArticle : this.getShoppingArticles()) {
            if (!shoppingArticle.getIdProduct().equals(article.getIdProduct())) continue;
            shoppingArticle.inc(article.getQuantity());
            this.addPartial(article.getQuantity(), article.getPrice(), article.getVat());
            return;
        }
        article.setShoppingCart(this);
        this.getShoppingArticles().add(article);
        this.addPartial(article.getQuantity(), article.getPrice(), article.getVat());
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getPartialAmount() {
        if (this.partialAmount == null) {
            this.partialAmount = new BigDecimal(0);
        }
        return this.partialAmount;
    }

    public BigDecimal getPartialTax() {
        if (this.partialTax == null) {
            this.partialTax = new BigDecimal(0);
        }
        return this.partialTax;
    }

    @Transient
    public double getTotal() {
        return this.getPartialAmount().add(this.getPartialTax()).doubleValue();
    }

    @Transient
    public double getTotalWithSipping() {
        return this.getPartialAmount().add(this.getPartialTax()).add(this.getShipping()).doubleValue();
    }

    public void addPartial(int quantity, BigDecimal price, BigDecimal vat) {
        BigDecimal singleAmount = null;
        if (price != null) {
            try {
                singleAmount = new BigDecimal(quantity).multiply(price).setScale(2);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        BigDecimal singleTax = null;
        if (vat != null) {
            try {
                singleTax = new BigDecimal(quantity).multiply(vat).setScale(2);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (singleAmount != null) {
            this.partialAmount = this.partialAmount.add(singleAmount);
        }
        if (singleTax != null) {
            this.partialTax = this.partialTax.add(singleTax);
        }
    }

    public void removeArticle(String idProduct) {
        if (!StringUtils.isEmpty((String)idProduct)) {
            ShoppingArticle toRemove = null;
            for (ShoppingArticle shoppingArticle : this.getShoppingArticles()) {
                if (!shoppingArticle.getIdProduct().equals(idProduct)) continue;
                toRemove = shoppingArticle;
                break;
            }
            if (toRemove != null) {
                this.addPartial(-toRemove.getQuantity(), toRemove.getPrice(), toRemove.getVat());
                this.getShoppingArticles().remove(toRemove);
            }
        }
    }

    public void changeArticleQuantity(String idProduct, int quantity) {
        if (!StringUtils.isEmpty((String)idProduct)) {
            for (ShoppingArticle shoppingArticle : this.getShoppingArticles()) {
                if (!shoppingArticle.getIdProduct().equals(idProduct)) continue;
                if (shoppingArticle.getQuantity() + quantity <= 0) {
                    quantity = 1 - shoppingArticle.getQuantity();
                    break;
                }
                shoppingArticle.setQuantity(shoppingArticle.getQuantity() + quantity);
                this.addPartial(quantity, shoppingArticle.getPrice(), shoppingArticle.getVat());
                break;
            }
        }
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    public BillingAddress getBillingAddress() {
        if (this.billingAddress == null) {
            this.billingAddress = new BillingAddress();
        }
        return this.billingAddress;
    }

    public void setBillingAddress(BillingAddress billingAddress) {
        this.billingAddress = billingAddress;
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    public ShippingAddress getShippingAddress() {
        if (this.shippingAddress == null) {
            this.shippingAddress = new ShippingAddress();
        }
        return this.shippingAddress;
    }

    public void setShippingAddress(ShippingAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public void setPartialAmount(BigDecimal partialAmount) {
        this.partialAmount = partialAmount;
    }

    public void setPartialTax(BigDecimal partialTax) {
        this.partialTax = partialTax;
    }

    public BigDecimal getShipping() {
        return this.shipping;
    }

    public void setShipping(BigDecimal shipping) {
        this.shipping = shipping;
    }

    public Long getLogId() {
        return this.logId;
    }

    public void setLogId(Long logId) {
        this.logId = logId;
    }

    @Lob
    @Column(length=1024)
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Enumerated(value=EnumType.STRING)
    public PaypalStatus getPaypalStatus() {
        return this.paypalStatus;
    }

    public void setPaypalStatus(PaypalStatus paypalStatus) {
        this.paypalStatus = paypalStatus;
    }

    @Transient
    public boolean isRefunded() {
        return this.paypalStatus != null && this.paypalStatus.equals((Object)PaypalStatus.Refunded);
    }

    @Transient
    public boolean isCompleted() {
        return this.paypalStatus != null && this.paypalStatus.equals((Object)PaypalStatus.Completed);
    }

    @Transient
    public boolean isInit() {
        return this.paypalStatus != null && this.paypalStatus.equals((Object)PaypalStatus.Init);
    }

    @Transient
    public boolean isUndo() {
        return this.paypalStatus != null && this.paypalStatus.equals((Object)PaypalStatus.Undo);
    }

    @Transient
    public boolean isSent() {
        return this.paypalStatus != null && this.paypalStatus.equals((Object)PaypalStatus.Sent);
    }

    @Transient
    public boolean isNotCompleted() {
        return this.paypalStatus != null && this.paypalStatus.equals((Object)PaypalStatus.NotCompleted);
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getRefundedDate() {
        return this.refundedDate;
    }

    public void setRefundedDate(Date refundedDate) {
        this.refundedDate = refundedDate;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getInitDate() {
        return this.initDate;
    }

    public void setInitDate(Date initDate) {
        this.initDate = initDate;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getUndoDate() {
        return this.undoDate;
    }

    public void setUndoDate(Date undoDate) {
        this.undoDate = undoDate;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getNotCompletedDate() {
        return this.notCompletedDate;
    }

    public void setNotCompletedDate(Date notCompletedDate) {
        this.notCompletedDate = notCompletedDate;
    }

    public String toString() {
        return "ShoppingCart [active=" + this.active + ", id=" + this.id + ", refundedDate=" + this.refundedDate + ", completedDate=" + this.completedDate + ", initDate=" + this.initDate + ", undoDate=" + this.undoDate + ", sentDate=" + this.sentDate + ", notCompletedDate=" + this.notCompletedDate + ", partialAmount=" + this.partialAmount + ", partialTax=" + this.partialTax + ", shipping=" + this.shipping + ", currency=" + this.currency + ", billingAddress=" + this.billingAddress + ", shippingAddress=" + this.shippingAddress + ", shoppingArticles=" + this.shoppingArticles + ", logId=" + this.logId + ", notes=" + this.notes + ", paypalStatus=" + (Object)((Object)this.paypalStatus) + "]";
    }
}

