/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.paypalweb.service;

import java.io.File;
import java.util.Arrays;
import javax.ejb.Asynchronous;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.giavacms.base.service.EmailSession;
import org.giavacms.paypalweb.model.PaypalConfiguration;
import org.giavacms.paypalweb.model.ShoppingCart;
import org.giavacms.paypalweb.repository.PaypalConfigurationRepository;
import org.giavacms.paypalweb.util.PlaceholderUtils;
import org.jboss.logging.Logger;

@Stateless
@LocalBean
public class NotificationService {
    Logger logger = Logger.getLogger((String)this.getClass().getName());
    @Inject
    EmailSession emailSession;
    @Inject
    PaypalConfigurationRepository paypalConfigurationRepository;

    @Asynchronous
    public void notifyCompleted(ShoppingCart shoppingCart) {
        PaypalConfiguration paypalConfiguration = this.paypalConfigurationRepository.load();
        String from = paypalConfiguration.getEmailSender();
        String body = PlaceholderUtils.replaceAll(paypalConfiguration.getEmailBody(), shoppingCart, paypalConfiguration.getShoppingCartDirectUrl());
        String title = PlaceholderUtils.replaceAll(paypalConfiguration.getEmailObject(), shoppingCart, paypalConfiguration.getShoppingCartDirectUrl());
        String[] to = new String[]{shoppingCart.getBillingAddress().getEmail()};
        String[] cc = null;
        String[] bcc = paypalConfiguration.getEmailNotification() != null && paypalConfiguration.getEmailNotification().length() > 0 ? paypalConfiguration.getEmailNotification().split(";") : new String[]{};
        File file = null;
        if (!paypalConfiguration.isLogOnly()) {
            this.emailSession.sendEmail(from, body, title, to, cc, bcc, file);
        } else {
            this.log(shoppingCart.getPaypalStatus().name(), from, body, title, to, cc, bcc);
        }
    }

    @Asynchronous
    public void notifySent(ShoppingCart shoppingCart) {
        PaypalConfiguration paypalConfiguration = this.paypalConfigurationRepository.load();
        String from = paypalConfiguration.getEmailSender();
        String body = PlaceholderUtils.replaceAll(paypalConfiguration.getEmailShipmentBody(), shoppingCart, paypalConfiguration.getShoppingCartDirectUrl());
        String title = PlaceholderUtils.replaceAll(paypalConfiguration.getEmailShipmentObject(), shoppingCart, paypalConfiguration.getShoppingCartDirectUrl());
        String[] to = new String[]{shoppingCart.getBillingAddress().getEmail()};
        String[] cc = null;
        String[] bcc = paypalConfiguration.getEmailNotification() != null && paypalConfiguration.getEmailNotification().length() > 0 ? paypalConfiguration.getEmailNotification().split(";") : new String[]{};
        File file = null;
        if (!paypalConfiguration.isLogOnly()) {
            this.emailSession.sendEmail(from, body, title, to, cc, bcc, file);
        } else {
            this.log(shoppingCart.getPaypalStatus().name(), from, body, title, to, cc, bcc);
        }
    }

    @Asynchronous
    public void notifyRefunded(ShoppingCart shoppingCart) {
        PaypalConfiguration paypalConfiguration = this.paypalConfigurationRepository.load();
        String from = paypalConfiguration.getEmailSender();
        String body = PlaceholderUtils.replaceAll(paypalConfiguration.getEmailRollBackBody(), shoppingCart, paypalConfiguration.getShoppingCartDirectUrl());
        String title = PlaceholderUtils.replaceAll(paypalConfiguration.getEmailRollBackObject(), shoppingCart, paypalConfiguration.getShoppingCartDirectUrl());
        String[] to = new String[]{shoppingCart.getBillingAddress().getEmail()};
        String[] cc = null;
        String[] bcc = paypalConfiguration.getEmailNotification() != null && paypalConfiguration.getEmailNotification().length() > 0 ? paypalConfiguration.getEmailNotification().split(";") : new String[]{};
        File file = null;
        if (!paypalConfiguration.isLogOnly()) {
            this.emailSession.sendEmail(from, body, title, to, cc, bcc, file);
        } else {
            this.log(shoppingCart.getPaypalStatus().name(), from, body, title, to, cc, bcc);
        }
    }

    private void log(String type, String from, String body, String title, String[] to, String[] cc, String[] bcc) {
        this.logger.info((Object)("EMAIL FOR SHOPPING CART TYPE: " + type));
        this.logger.info((Object)("from: " + from));
        this.logger.info((Object)("body: " + body));
        this.logger.info((Object)("title: " + title));
        this.logger.info((Object)("to: " + Arrays.toString(to)));
        this.logger.info((Object)("cc: " + Arrays.toString(to)));
        this.logger.info((Object)("bcc:" + Arrays.toString(to)));
    }
}

