/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.paypalweb.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.view.ViewDeclarationLanguage;

public class FaceletRenderer {
    public static String renderView(String template) {
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            ResponseWriter originalWriter = context.getResponseWriter();
            StringWriter stringWriter = new StringWriter();
            ResponseWriter writer = FaceletRenderer.createResponseWriter(context, stringWriter);
            context.setResponseWriter(writer);
            ViewHandler viewHandler = context.getApplication().getViewHandler();
            UIViewRoot view = viewHandler.createView(context, template);
            ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(context, template);
            vdl.buildView(context, view);
            FaceletRenderer.renderChildren(context, (UIComponent)view);
            if (originalWriter != null) {
                context.setResponseWriter(originalWriter);
            }
            return stringWriter.toString();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static ResponseWriter createResponseWriter(FacesContext context, Writer writer) {
        ExternalContext extContext = context.getExternalContext();
        Map requestMap = extContext.getRequestMap();
        String contentType = (String)requestMap.get("facelets.ContentType");
        String encoding = (String)requestMap.get("facelets.Encoding");
        RenderKit renderKit = context.getRenderKit();
        return renderKit.createResponseWriter(writer, contentType, encoding);
    }

    private static void renderChildren(FacesContext context, UIComponent component) throws IOException {
        List children = component.getChildren();
        int size = component.getChildCount();
        for (int i = 0; i < size; ++i) {
            UIComponent child = (UIComponent)children.get(i);
            FaceletRenderer.renderChild(context, child);
        }
    }

    private static void renderChild(FacesContext context, UIComponent child) throws IOException {
        if (child.isRendered()) {
            child.encodeAll(context);
        }
    }
}

