/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.resolver.controller.request;

import com.ocpsoft.pretty.PrettyContext;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.enterprise.context.RequestScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletContext;
import org.giavacms.base.controller.request.BreadCrumpsHandler;
import org.giavacms.base.controller.request.PageRequestController;
import org.jboss.logging.Logger;

@Named
@RequestScoped
public class UrlParsingBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    PageRequestController pageRequestController;
    @Inject
    BreadCrumpsHandler breadCrumpsHandler;
    protected Logger logger = Logger.getLogger((String)this.getClass().getName());
    private String idPage;

    private boolean isInAdditionalParams(String uri) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        String additionalUri = ctx.getExternalContext().getInitParameter("additionalUri");
        if (additionalUri != null && !additionalUri.isEmpty()) {
            return uri.startsWith(additionalUri);
        }
        return false;
    }

    public String parseComplexUrl() throws UnsupportedEncodingException {
        this.logger.info((Object)"start uri****************");
        String uri = PrettyContext.getCurrentInstance().getRequestURL().toURL();
        this.logger.info((Object)("uri: " + uri));
        this.logger.info((Object)"stop uri****************");
        String pageId = uri.substring(uri.lastIndexOf("/") + 1);
        this.logger.info((Object)"start pageId****************");
        this.logger.info((Object)("pageId: " + pageId));
        this.logger.info((Object)"stop pageId****************");
        if (!uri.startsWith("/s/") && !uri.startsWith("/p/") && !uri.startsWith("/c/") && !this.isInAdditionalParams(uri) || uri.endsWith("js") || uri.endsWith("css") || uri.endsWith("png") || uri.endsWith("gif") || uri.endsWith("jpg") || uri.endsWith("jpeg")) {
            this.logger.info((Object)("skip: " + uri));
            return uri;
        }
        String contextPath = PrettyContext.getCurrentInstance().getContextPath();
        this.logger.info((Object)("contextPath: " + contextPath));
        this.breadCrumpsHandler.setBreadCrump(contextPath + uri);
        if (uri.startsWith("/c/")) {
            this.logger.info((Object)("forcing cached version for: " + pageId));
            this.pageRequestController.setUri(uri);
            this.pageRequestController.getElement().setId(pageId);
            return "/cache/" + pageId + ".xhtml";
        }
        if (new File(((ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext()).getRealPath("cache"), pageId + ".xhtml").exists()) {
            this.logger.info((Object)("cached version for: " + pageId));
            this.pageRequestController.setUri(uri);
            this.pageRequestController.getElement().setId(pageId);
            return "/cache/" + pageId + ".xhtml";
        }
        this.pageRequestController.setUri(uri);
        this.pageRequestController.getElement().setId(pageId);
        return "/db:" + pageId;
    }

    public String getIdPage() {
        return this.idPage;
    }

    public void setIdPage(String idPage) {
        this.idPage = idPage;
    }
}

