/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.richcontent.controller;

import java.util.ArrayList;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.common.util.FileUtils;
import org.giavacms.base.controller.AbstractPageController;
import org.giavacms.base.model.attachment.Document;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.base.repository.PageRepository;
import org.giavacms.base.repository.TemplateImplRepository;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.richcontent.model.RichContent;
import org.giavacms.richcontent.model.type.RichContentType;
import org.giavacms.richcontent.producer.RichContentProducer;
import org.giavacms.richcontent.repository.RichContentRepository;
import org.giavacms.richcontent.repository.RichContentTypeRepository;
import org.giavacms.richcontent.repository.TagRepository;
import org.primefaces.event.FileUploadEvent;

@Named
@SessionScoped
public class RichContentController
extends AbstractPageController<RichContent> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    public static String VIEW = "/private/richcontent/view.xhtml";
    @ListPage
    public static String LIST = "/private/richcontent/list.xhtml";
    @EditPage
    public static String NEW_OR_EDIT = "/private/richcontent/edit.xhtml";
    public static String EDIT_DOCS = "/private/richcontent/edit-documents.xhtml";
    @Inject
    @OwnRepository(value=RichContentRepository.class)
    RichContentRepository richContentRepository;
    @Inject
    TemplateImplRepository templateImplRepository;
    @Inject
    PageRepository pageRepository;
    @Inject
    RichContentTypeRepository richContentTypeRepository;
    @Inject
    TagRepository tagRepository;
    @Inject
    RichContentProducer richContentProducer;

    public String getExtension() {
        return "RichContent";
    }

    public void handleUpload(FileUploadEvent event) {
        this.logger.info((Object)("Uploaded: " + event.getFile().getFileName() + " - " + event.getFile().getContentType() + "- " + event.getFile().getSize()));
        String type = FileUtils.getType((String)event.getFile().getFileName());
        if (type.equals(FileUtils.IMG)) {
            this.handleImgUpload(event);
        } else {
            this.handleFileUpload(event);
        }
    }

    public void handleFileUpload(FileUploadEvent event) {
        Document doc = new Document();
        doc.setUploadedData(event.getFile());
        doc.setData(event.getFile().getContents());
        doc.setType(event.getFile().getContentType());
        String filename = FileUtils.createFile_((String)"docs", (String)event.getFile().getFileName(), (byte[])event.getFile().getContents());
        doc.setFilename(filename);
        ((RichContent)((Object)this.getElement())).getDocuments().add(doc);
    }

    public void handleImgUpload(FileUploadEvent event) {
        try {
            byte[] imgRes = event.getFile().getContents();
            Image img = new Image();
            img.setUploadedData(event.getFile());
            img.setData(imgRes);
            img.setType(event.getFile().getContentType());
            String filename = FileUtils.createImage_((String)"img", (String)event.getFile().getFileName(), (byte[])imgRes);
            img.setFilename(filename);
            ((RichContent)((Object)this.getElement())).getImages().add(img);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeDocument(Long id) {
        if (id != null && this.getElement() != null && ((RichContent)((Object)this.getElement())).getDocuments() != null && ((RichContent)((Object)this.getElement())).getDocuments().size() > 0) {
            ArrayList<Document> docsNew = new ArrayList<Document>();
            for (Document doc : ((RichContent)((Object)this.getElement())).getDocuments()) {
                if (doc.getId() == null || doc.getId().equals(id)) continue;
                docsNew.add(doc);
            }
            ((RichContent)((Object)this.getElement())).setDocuments(docsNew);
            this.richContentRepository.update(this.getElement());
        } else {
            this.logger.info((Object)("removeImage: non posso rimuovere id:" + id));
        }
    }

    public void removeImage(Long id) {
        if (id != null && this.getElement() != null && ((RichContent)((Object)this.getElement())).getImages() != null && ((RichContent)((Object)this.getElement())).getImages().size() > 0) {
            ArrayList<Image> imagesNew = new ArrayList<Image>();
            for (Image img : ((RichContent)((Object)this.getElement())).getImages()) {
                if (img.getId() == null || img.getId().equals(id)) continue;
                imagesNew.add(img);
            }
            ((RichContent)((Object)this.getElement())).setImages(imagesNew);
            this.richContentRepository.update(this.getElement());
        } else {
            this.logger.info((Object)("removeImage: non posso rimuovere id:" + id));
        }
    }

    public String save() {
        ((RichContent)((Object)this.getElement())).setTemplate(((RichContentType)this.richContentTypeRepository.find(((RichContent)((Object)this.getElement())).getRichContentType().getId())).getPage().getTemplate());
        if (super.save() == null) {
            return null;
        }
        this.tagRepository.set(((RichContent)((Object)this.getElement())).getId(), ((RichContent)((Object)this.getElement())).getTagList(), ((RichContent)((Object)this.getElement())).getDate());
        this.richContentProducer.reset();
        if (((RichContent)((Object)this.getElement())).isHighlight()) {
            this.richContentRepository.refreshEvidenza(((RichContent)((Object)this.getElement())).getId());
        }
        return super.viewPage();
    }

    public String delete() {
        return super.delete();
    }

    public String update() {
        ((RichContent)((Object)this.getElement())).setTemplate(((RichContentType)this.richContentTypeRepository.find(((RichContent)((Object)this.getElement())).getRichContentType().getId())).getPage().getTemplate());
        if (super.update() == null) {
            return null;
        }
        this.tagRepository.set(((RichContent)((Object)this.getElement())).getId(), ((RichContent)((Object)this.getElement())).getTagList(), ((RichContent)((Object)this.getElement())).getDate());
        this.richContentProducer.reset();
        if (((RichContent)((Object)this.getElement())).isHighlight()) {
            this.richContentRepository.refreshEvidenza(((RichContent)((Object)this.getElement())).getId());
        }
        return super.viewPage();
    }

    public String modDocumentsCurrent() {
        super.modCurrent();
        return EDIT_DOCS + "?faces-redirect=true";
    }

    public String modDocuments() {
        super.modElement();
        return EDIT_DOCS + "?faces-redirect=true";
    }

    public void filterTag(String tagName) {
        ((RichContent)((Object)this.getSearch().getObj())).setTag(tagName);
        this.refreshModel();
    }
}

