/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.richcontent.controller.request;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.controller.request.PageRequestController;
import org.giavacms.base.pojo.I18nParams;
import org.giavacms.base.request.I18nProducer;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.controller.AbstractRequestController;
import org.giavacms.common.model.Search;
import org.giavacms.common.util.BeanUtils;
import org.giavacms.richcontent.model.RichContent;
import org.giavacms.richcontent.model.type.RichContentType;
import org.giavacms.richcontent.repository.RichContentRepository;
import org.giavacms.richcontent.repository.RichContentTypeRepository;

@Named
@RequestScoped
public class RichContentRequestController
extends AbstractRequestController<RichContent>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_CONTENT = "q";
    public static final String PARAM_TYPE = "type";
    public static final String ID_PARAM = "id";
    public static final String CURRENT_PAGE_PARAM = "currentpage";
    public static final String[] PARAM_NAMES = new String[]{"q", "type", "id", "currentpage"};
    @Inject
    @OwnRepository(value=RichContentRepository.class)
    RichContentRepository richContentRepository;
    @Inject
    RichContentTypeRepository richContentTypeRepository;
    @Inject
    I18nParams i18nParams;
    private String filter;
    private RichContent last;

    protected void init() {
        super.init();
        this.testI18N();
    }

    public List<RichContent> loadPage(int startRow, int pageSize) {
        Search r = new Search(RichContent.class);
        ((RichContent)((Object)r.getObj())).setTitle((String)this.getParams().get(PARAM_CONTENT));
        ((RichContent)((Object)r.getObj())).getRichContentType().setName((String)this.getParams().get(PARAM_TYPE));
        if (this.getFilter() != null && !this.getFilter().isEmpty()) {
            ((RichContent)((Object)r.getObj())).getRichContentType().setName(this.getFilter());
        }
        return this.richContentRepository.getList((Search<RichContent>)r, startRow, pageSize);
    }

    public List<RichContent> getLatest(int pageSize) {
        this.logger.info((Object)("getLatest:" + pageSize));
        Search r = new Search(RichContent.class);
        return this.richContentRepository.getList((Search<RichContent>)r, 0, pageSize);
    }

    public List<RichContent> getPageOfSizeWithCategory(int size, String category) {
        this.setFilter(category);
        this.setPageSize(size);
        return this.getPage();
    }

    public int totalSize() {
        Search r = new Search(RichContent.class);
        ((RichContent)((Object)r.getObj())).getRichContentType().setName((String)this.getParams().get(PARAM_TYPE));
        ((RichContent)((Object)r.getObj())).setTitle((String)this.getParams().get(PARAM_CONTENT));
        if (this.getFilter() != null && !this.getFilter().isEmpty()) {
            ((RichContent)((Object)r.getObj())).getRichContentType().setName(this.getFilter());
        }
        return this.richContentRepository.getListSize(r);
    }

    public String[] getParamNames() {
        return PARAM_NAMES;
    }

    public String getIdParam() {
        return ID_PARAM;
    }

    public List<String> getTipiRichContent() {
        Search r = new Search(RichContentType.class);
        List rntl = this.richContentTypeRepository.getList(r, 0, 0);
        ArrayList<String> l = new ArrayList<String>();
        for (RichContentType rnt : rntl) {
            l.add(rnt.getName());
        }
        return l;
    }

    public String getRichContentTypeOptionsHTML() {
        StringBuffer sb = new StringBuffer();
        Search r = new Search(RichContentType.class);
        List rntl = this.richContentTypeRepository.getList(r, 0, 0);
        for (RichContentType richContentType : rntl) {
            sb.append("<option value=\"").append(richContentType.getName()).append("\"").append(richContentType.getName().equals(this.getParams().get(PARAM_TYPE)) ? " selected=\"selected\"" : "").append(">").append(richContentType.getName()).append("</option>");
        }
        return sb.toString();
    }

    public String getCurrentPageParam() {
        return CURRENT_PAGE_PARAM;
    }

    public boolean isScheda() {
        return this.getElement() != null && ((RichContent)((Object)this.getElement())).getId() != null;
    }

    public String viewElement(Long id) {
        this.setElement((Object)this.richContentRepository.fetch(id));
        return this.viewPage();
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public RichContent getLast(String category) {
        if (this.last == null) {
            RichContent last;
            this.last = last = this.richContentRepository.getLast(category);
        }
        return this.last;
    }

    protected void testI18N() {
        if (this.i18nParams == null) {
            this.logger.info((Object)"Attenzione: ancora non funziona l'inject diretta degli I18nParams. Per ottenereli recuperiamo il loro producer dal contesto cdi");
            I18nProducer i18nProducer = (I18nProducer)BeanUtils.getBean(I18nProducer.class);
            this.i18nParams = i18nProducer.getI18nParams();
        } else {
            this.logger.info((Object)"Attenzione: parametri I18nParams gia' presenti. Ma se in precedenza ho stampato il messaggio dell'inject che non funziona vuol dire che sto passando due volte per questo metodo, CIOE' CHE STO CREANDO DUE VOLTE UN REQUEST CONTROLLER !?!?!");
        }
        String testName = "test";
        int currentLang = ((PageRequestController)BeanUtils.getBean(PageRequestController.class)).getElement().getLang();
        String testValue = this.i18nParams.get(currentLang, testName);
        if (testValue != null && testValue.trim().length() > 0) {
            for (int i = 0; i < this.i18nParams.getLanguages().length; ++i) {
                if (i == currentLang) continue;
                this.i18nParams.put(i, testName, this.i18nParams.getLanguages()[i] == null || !this.i18nParams.getLanguages()[i].isEnabled() ? "UNSUPPORTED" : testValue + "_" + this.i18nParams.getLanguages()[i].getId());
            }
        }
    }
}

