/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.richcontent.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.giavacms.base.common.util.HtmlUtils;
import org.giavacms.base.model.Page;
import org.giavacms.base.model.attachment.Document;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.richcontent.model.type.RichContentType;

@Entity
@DiscriminatorValue(value="RichContent")
public class RichContent
extends Page {
    private static final long serialVersionUID = 1L;
    public static final String EXTENSION = "RichContent";
    private static final String TAG_SEPARATOR = ",";
    private String preview;
    private String content;
    private String author;
    private Date date;
    private RichContentType richContentType;
    private List<Document> documents;
    private List<Image> images;
    private boolean highlight;
    private String tag;
    private List<String> tagList;
    private String tags;

    public RichContent() {
        super.setExtension(EXTENSION);
    }

    @Transient
    public String getContentN() {
        return HtmlUtils.normalizeHtml((String)this.content);
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="RichContent_Document", joinColumns={@JoinColumn(name="RichContent_id")}, inverseJoinColumns={@JoinColumn(name="documents_id")})
    public List<Document> getDocuments() {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>();
        }
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    public void addDocument(Document document) {
        this.getDocuments().add(document);
    }

    @Transient
    public int getDocSize() {
        return this.getDocuments().size();
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="RichContent_Image", joinColumns={@JoinColumn(name="RichContent_id")}, inverseJoinColumns={@JoinColumn(name="images_id")})
    public List<Image> getImages() {
        if (this.images == null) {
            this.images = new ArrayList<Image>();
        }
        return this.images;
    }

    @Transient
    public Image getImage() {
        if (this.getImages() != null && this.getImages().size() > 0) {
            return this.getImages().get(0);
        }
        return null;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public void addImage(Image image) {
        this.getImages().add(image);
    }

    @Transient
    public int getImgSize() {
        return this.getImages().size();
    }

    @ManyToOne
    public RichContentType getRichContentType() {
        if (this.richContentType == null) {
            this.richContentType = new RichContentType();
        }
        return this.richContentType;
    }

    public void setRichContentType(RichContentType richContentType) {
        this.richContentType = richContentType;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    @Lob
    public String getPreview() {
        return this.preview;
    }

    public void setPreview(String preview) {
        this.preview = preview;
    }

    @Lob
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String toString() {
        return "RichContent [id=" + super.getId() + ", active=" + super.isActive() + ", title=" + super.getTitle() + ", preview=" + this.preview + ", content=" + this.content + ", author=" + this.author + ", date=" + this.date + ", tags=" + this.tags + ", richContentType=" + this.richContentType.getName() + ", highlight=" + this.highlight + "]";
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
        this.tagList = null;
    }

    @Transient
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Transient
    public List<String> getTagList() {
        String[] tagArray;
        if (this.tagList != null) {
            return this.tagList;
        }
        this.tagList = new ArrayList<String>();
        if (this.tags == null) {
            return this.tagList;
        }
        for (String tag : tagArray = this.tags.split(TAG_SEPARATOR)) {
            if (tag == null || tag.trim().length() <= 0) continue;
            this.tagList.add(tag.trim());
        }
        return this.tagList;
    }
}

