/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.richcontent.producer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Produces;
import javax.faces.model.SelectItem;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.common.model.Group;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.Repository;
import org.giavacms.common.util.JSFUtils;
import org.giavacms.richcontent.model.Tag;
import org.giavacms.richcontent.model.type.RichContentType;
import org.giavacms.richcontent.repository.RichContentTypeRepository;
import org.giavacms.richcontent.repository.TagRepository;
import org.jboss.logging.Logger;

@Named
@SessionScoped
public class RichContentProducer
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Logger logger = Logger.getLogger((String)this.getClass().getCanonicalName());
    private Map<Class, SelectItem[]> items = null;
    @Inject
    RichContentTypeRepository richContentTypeRepository;
    @Inject
    TagRepository tagRepository;
    private List<Group<Tag>> tags;

    @PostConstruct
    public void reset() {
        this.logger.info((Object)"reset");
        this.items = new HashMap<Class, SelectItem[]>();
        this.tags = null;
    }

    public void resetItemsForClass(Class clazz) {
        if (this.items.containsKey(clazz)) {
            this.items.remove(clazz);
        }
    }

    @Produces
    @Named
    public SelectItem[] getRichContentTypeItems() {
        if (this.items.get(RichContentType.class) == null) {
            this.items.put(RichContentType.class, JSFUtils.setupItems((Search)new Search(RichContentType.class), (Repository)this.richContentTypeRepository, (String)"id", (String)"name", (String)"nessuna categoria", (String)"seleziona categoria contenuto..."));
        }
        return this.items.get(RichContentType.class);
    }

    @Produces
    @Named
    public List<Group<Tag>> getTags() {
        if (this.tags == null) {
            Search st = new Search(Tag.class);
            st.setGrouping("tagName");
            this.tags = this.tagRepository.getGroups(st, 0, 50);
        }
        return this.tags;
    }
}

