/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.richcontent.repository;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Named;
import org.giavacms.base.common.util.HtmlUtils;
import org.giavacms.base.controller.util.TimeUtils;
import org.giavacms.base.model.Page;
import org.giavacms.base.model.attachment.Document;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.base.repository.AbstractPageRepository;
import org.giavacms.common.model.Search;
import org.giavacms.richcontent.model.RichContent;
import org.giavacms.richcontent.model.Tag;
import org.giavacms.richcontent.model.type.RichContentType;

@Named
@Stateless
@LocalBean
public class RichContentRepository
extends AbstractPageRepository<RichContent> {
    private static final long serialVersionUID = 1L;

    protected void applyRestrictions(Search<RichContent> search, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(alias).append(".richContentType.active = :activeContentType ");
        params.put("activeContentType", true);
        separator = " and ";
        if (((RichContent)((Object)search.getObj())).getRichContentType() != null && ((RichContent)((Object)search.getObj())).getRichContentType().getName() != null && ((RichContent)((Object)search.getObj())).getRichContentType().getName().length() > 0) {
            sb.append(separator).append(alias).append(".richContentType.name = :NAMETYPE ");
            params.put("NAMETYPE", ((RichContent)((Object)search.getObj())).getRichContentType().getName());
            separator = " and ";
        }
        if (((RichContent)((Object)search.getObj())).getRichContentType() != null && ((RichContent)((Object)search.getObj())).getRichContentType().getId() != null) {
            sb.append(separator).append(alias).append(".richContentType.id = :IDTYPE ");
            params.put("IDTYPE", ((RichContent)((Object)search.getObj())).getRichContentType().getId());
            separator = " and ";
        }
        if (((RichContent)((Object)search.getObj())).getTag() != null && ((RichContent)((Object)search.getObj())).getTag().trim().length() > 0) {
            sb.append(separator).append(alias).append(".id in ( ");
            sb.append(" select distinct rt.richContent.id from ").append(Tag.class.getSimpleName()).append(" rt where rt.tagName = :TAGNAME ");
            sb.append(" ) ");
            params.put("TAGNAME", ((RichContent)((Object)search.getObj())).getTag().trim());
            separator = " and ";
        }
        if (((RichContent)((Object)search.getObj())).getTagList().size() > 0) {
            sb.append(separator).append(" ( ");
            for (int i = 0; i < ((RichContent)((Object)search.getObj())).getTagList().size(); ++i) {
                sb.append(i > 0 ? " or " : "");
                boolean usaJoin = false;
                if (usaJoin) {
                    sb.append(alias).append(".id in ( ");
                    sb.append(" select distinct rt.richContent.id from ").append(Tag.class.getSimpleName()).append(" rt where upper ( rt.tagName ) like :TAGNAME").append(i).append(" ");
                    sb.append(" ) ");
                } else {
                    sb.append(" upper ( ").append(alias).append(".tags ) like :TAGNAME").append(i).append(" ");
                }
                params.put("TAGNAME" + i, this.likeParam(((RichContent)((Object)search.getObj())).getTag().trim().toUpperCase()));
            }
            separator = " and ";
        }
        super.applyRestrictions(search, alias, separator, sb, params);
    }

    protected boolean likeSearch(String likeText, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(" ( ");
        sb.append(" upper ( ").append(alias).append(".title ) LIKE :LIKETEXT ");
        sb.append(" or ").append(" upper ( ").append(alias).append(".content ) LIKE :LIKETEXT ");
        sb.append(" ) ");
        params.put("LIKETEXT", likeText);
        return true;
    }

    protected RichContent prePersist(RichContent n) {
        n.setClone(true);
        if (n.getDate() == null) {
            n.setDate(new Date());
        }
        if (n.getRichContentType() != null && n.getRichContentType().getId() != null) {
            n.setRichContentType((RichContentType)this.getEm().find(RichContentType.class, (Object)n.getRichContentType().getId()));
        }
        if (n.getDocuments() != null && n.getDocuments().size() == 0) {
            n.setDocuments(null);
        }
        if (n.getImages() != null && n.getImages().size() == 0) {
            n.setImages(null);
        }
        n.setDate(TimeUtils.adjustHourAndMinute((Date)n.getDate()));
        n.setContent(HtmlUtils.normalizeHtml((String)n.getContent()));
        return (RichContent)super.prePersist((Page)n);
    }

    protected RichContent preUpdate(RichContent n) {
        n.setClone(true);
        if (n.getDate() == null) {
            n.setDate(new Date());
        }
        if (n.getRichContentType() != null && n.getRichContentType().getId() != null) {
            n.setRichContentType((RichContentType)this.getEm().find(RichContentType.class, (Object)n.getRichContentType().getId()));
        }
        if (n.getDocuments() != null && n.getDocuments().size() == 0) {
            n.setDocuments(null);
        }
        if (n.getImages() != null && n.getImages().size() == 0) {
            n.setImages(null);
        }
        n.setDate(TimeUtils.adjustHourAndMinute((Date)n.getDate()));
        n.setContent(HtmlUtils.normalizeHtml((String)n.getContent()));
        n = (RichContent)super.preUpdate((Page)n);
        return n;
    }

    public RichContent findLast() {
        RichContent ret = new RichContent();
        try {
            ret = (RichContent)((Object)this.getEm().createQuery("select p from " + RichContent.class.getSimpleName() + " p order by p.date desc ").setMaxResults(1).getSingleResult());
            if (ret == null) {
                return null;
            }
            return this.fetch(ret.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
    }

    public RichContent findHighlight() {
        RichContent ret = new RichContent();
        try {
            ret = (RichContent)((Object)this.getEm().createQuery("select p from " + RichContent.class.getSimpleName() + " p where p.highlight = :STATUS ").setParameter("STATUS", (Object)true).setMaxResults(1).getSingleResult());
            for (Document document : ret.getDocuments()) {
                document.getName();
            }
            for (Image image : ret.getImages()) {
                image.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ret == null) {
            return this.findLast();
        }
        return ret;
    }

    public void refreshEvidenza(String id) {
        List ret = null;
        try {
            ret = this.getEm().createQuery("select p from " + RichContent.class.getSimpleName() + " p where p.id != :ID AND p.highlight = :STATUS").setParameter("ID", (Object)id).setParameter("STATUS", (Object)true).getResultList();
            if (ret != null) {
                for (RichContent richContent : ret) {
                    richContent.setHighlight(false);
                    this.update((Object)richContent);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Image findHighlightImage() {
        try {
            List nl = this.getEm().createQuery("select p from " + RichContent.class.getSimpleName() + " p where p.highlight = :STATUS").setParameter("STATUS", (Object)true).getResultList();
            if (nl == null || nl.size() == 0 || ((RichContent)((Object)nl.get(0))).getImages() == null || ((RichContent)((Object)nl.get(0))).getImages().size() == 0) {
                return null;
            }
            return ((RichContent)((Object)nl.get(0))).getImages().get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getDefaultOrderBy() {
        return "date desc";
    }

    public RichContent fetch(Object key) {
        try {
            RichContent richContent = (RichContent)((Object)this.find(key));
            for (Document document : richContent.getDocuments()) {
                document.getName();
            }
            for (Image image : richContent.getImages()) {
                image.getName();
            }
            return richContent;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
            return null;
        }
    }

    public RichContent getLast(String category) {
        Search r = new Search(RichContent.class);
        ((RichContent)((Object)r.getObj())).getRichContentType().setName(category);
        List<RichContent> list = this.getList((Search<RichContent>)r, 0, 1);
        if (list != null && list.size() > 0) {
            RichContent ret = list.get(0);
            for (Document document : ret.getDocuments()) {
                document.getName();
            }
            for (Image image : ret.getImages()) {
                image.getName();
            }
            return ret;
        }
        return new RichContent();
    }

    public List<RichContent> getList(Search<RichContent> ricerca, int startRow, int pageSize) {
        List list = super.getList(ricerca, startRow, pageSize);
        for (RichContent richContent : list) {
            if (richContent.getImages() != null) {
                for (Image img : richContent.getImages()) {
                    img.getId();
                    img.getFilename();
                    img.getFilePath();
                }
            }
            if (richContent.getDocuments() == null) continue;
            for (Document doc : richContent.getDocuments()) {
                doc.getId();
                doc.getFilename();
                doc.getType();
            }
        }
        return list;
    }
}

