/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.richcontent.repository;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.AbstractRepository;
import org.giavacms.richcontent.model.RichContent;
import org.giavacms.richcontent.model.Tag;

@Named
@Stateless
@LocalBean
public class TagRepository
extends AbstractRepository<Tag> {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    EntityManager em;

    protected EntityManager getEm() {
        return this.em;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    protected String getDefaultOrderBy() {
        return "tagName asc";
    }

    protected void applyRestrictions(Search<Tag> search, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        if (((Tag)search.getObj()).getRichContent() != null && ((Tag)search.getObj()).getRichContent().getId() != null && ((Tag)search.getObj()).getRichContent().getId().trim().length() > 0) {
            sb.append(separator).append(alias).append(".richContent.id = :RICHCONTENTID1 ");
            params.put("RICHCONTENTID1", ((Tag)search.getObj()).getRichContent().getId().trim());
            separator = " and ";
        }
        if (((Tag)search.getObj()).getRichContentId() != null && ((Tag)search.getObj()).getRichContentId().trim().length() > 0) {
            sb.append(separator).append(alias).append(".richContent.id = :RICHCONTENTID2 ");
            params.put("RICHCONTENTID2", ((Tag)search.getObj()).getRichContentId().trim());
            separator = " and ";
        }
        if (((Tag)search.getObj()).getTagName() != null && ((Tag)search.getObj()).getTagName().trim().length() > 0) {
            sb.append(separator).append(" upper ( ").append(alias).append(".tagName ) like :TAGNAME ");
            params.put("TAGNAME", this.likeParam(((Tag)search.getObj()).getTagName().trim().toUpperCase()));
            separator = " and ";
        }
        super.applyRestrictions(search, alias, separator, sb, params);
    }

    protected Tag construct(List<String> fieldNames, List<Object> fieldValues) {
        Tag t = new Tag();
        t.setRichContent(new RichContent());
        for (int i = 0; i < fieldNames.size(); ++i) {
            if ("tagName".equals(fieldNames.get(i))) {
                t.setTagName((String)fieldValues.get(i));
                continue;
            }
            if ("day".equals(fieldNames.get(i))) {
                t.setDay((Integer)fieldValues.get(i));
                continue;
            }
            if ("month".equals(fieldNames.get(i))) {
                t.setMonth((Integer)fieldValues.get(i));
                continue;
            }
            if (!"year".equals(fieldNames.get(i))) continue;
            t.setYear((Integer)fieldValues.get(i));
        }
        return t;
    }

    public void set(String richContentId, List<String> tagList, Date date) {
        this.getEm().createQuery("delete from " + Tag.class.getSimpleName() + " t where t.richContentId = :RICHCONTENTID ").setParameter("RICHCONTENTID", (Object)richContentId).executeUpdate();
        if (date == null) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int day = cal.get(5);
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        for (String tagName : tagList) {
            this.getEm().persist((Object)new Tag(tagName, richContentId, day, month, year));
        }
    }
}

