package org.giavacms.richcontent.repository;

import java.util.Map;

import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.giavacms.common.annotation.LogOperation;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.AbstractRepository;
import org.giavacms.richcontent.model.type.RichContentType;

@Named
@Stateless
@LocalBean
public class RichContentTypeRepository extends AbstractRepository<RichContentType>
{

   private static final long serialVersionUID = 1L;

   @PersistenceContext
   EntityManager em;

   @Override
   public EntityManager getEm()
   {
      return em;
   }

   @Override
   public void setEm(EntityManager em)
   {
      this.em = em;
   }

   @Override
   protected String getDefaultOrderBy()
   {
      return "name asc";
   }

   @Override
   protected void applyRestrictions(Search<RichContentType> search, String alias,
            String separator, StringBuffer sb, Map<String, Object> params)
   {
      sb.append(separator).append(alias).append(".active = :active");
      params.put("active", true);
      separator = " and ";
      if (search.getObj().getName() != null
               && !search.getObj().getName().isEmpty())
      {
         sb.append(separator).append(" upper(").append(alias)
                  .append(".name ) like :NAME ");
         params.put("NAME", likeParam(search.getObj().getName()
                  .toUpperCase()));
      }
   }

   @Override
   public boolean delete(Object key)
   {
      try
      {
         RichContentType richContentType = getEm().find(getEntityType(), key);
         if (richContentType != null)
         {
            richContentType.setActive(false);
            getEm().merge(richContentType);
         }
         return true;
      }
      catch (Exception e)
      {
         logger.error(e.getMessage());
         return false;
      }
   }

}
