/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.richcontent.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.annotation.DefaultResourceController;
import org.giavacms.base.common.util.ResourceUtils;
import org.giavacms.base.controller.AbstractPageController;
import org.giavacms.base.controller.ResourceController;
import org.giavacms.base.model.attachment.Document;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.base.model.enums.ResourceType;
import org.giavacms.base.pojo.Resource;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.common.model.Group;
import org.giavacms.common.model.Search;
import org.giavacms.common.util.MimeUtils;
import org.giavacms.richcontent.model.RichContent;
import org.giavacms.richcontent.model.Tag;
import org.giavacms.richcontent.model.type.RichContentType;
import org.giavacms.richcontent.repository.RichContentRepository;
import org.giavacms.richcontent.repository.RichContentTypeRepository;
import org.giavacms.richcontent.repository.TagRepository;
import org.primefaces.event.FileUploadEvent;

@Named
@SessionScoped
public class RichContentController
extends AbstractPageController<RichContent> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    public static String VIEW = "/private/richcontent/view.xhtml";
    @ListPage
    public static String LIST = "/private/richcontent/list.xhtml";
    @EditPage
    public static String NEW_OR_EDIT = "/private/richcontent/edit.xhtml";
    public static String EDIT_DOCS = "/private/richcontent/edit-documents.xhtml";
    @Inject
    @OwnRepository(value=RichContentRepository.class)
    RichContentRepository richContentRepository;
    @Inject
    RichContentTypeRepository richContentTypeRepository;
    @Inject
    TagRepository tagRepository;
    @Inject
    @DefaultResourceController
    ResourceController resourceController;
    private List<Group<Tag>> tags;

    public String getExtension() {
        return "RichContent";
    }

    public void handleUpload(FileUploadEvent event) {
        this.logger.info((Object)("Uploaded: " + event.getFile().getFileName() + " - " + event.getFile().getContentType() + "- " + event.getFile().getSize()));
        String type = ResourceUtils.getType((String)event.getFile().getFileName());
        if (ResourceType.IMAGE.name().equals(type)) {
            this.handleImgUpload(event);
        } else {
            this.handleFileUpload(event);
        }
    }

    public void handleFileUpload(FileUploadEvent event) {
        Document doc = new Document();
        doc.setUploadedData(event.getFile());
        doc.setData(event.getFile().getContents());
        doc.setType(event.getFile().getContentType());
        String filename = ResourceUtils.createFile_((String)"docs", (String)event.getFile().getFileName(), (byte[])event.getFile().getContents());
        doc.setFilename(filename);
        ((RichContent)((Object)this.getElement())).getDocuments().add(doc);
    }

    public void handleImgUpload(FileUploadEvent event) {
        try {
            byte[] imgRes = event.getFile().getContents();
            Image img = new Image();
            img.setUploadedData(event.getFile());
            img.setData(imgRes);
            img.setType(event.getFile().getContentType());
            String filename = ResourceUtils.createImage_((String)"img", (String)event.getFile().getFileName(), (byte[])imgRes);
            img.setFilename(filename);
            ((RichContent)((Object)this.getElement())).getImages().add(img);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeDocument(Long order) {
        this.removeDocument(order.intValue());
    }

    public void removeDocument(Integer order) {
        if (order != null && order > 0 && this.getElement() != null && ((RichContent)((Object)this.getElement())).getDocuments() != null && ((RichContent)((Object)this.getElement())).getDocuments().size() > 0 && ((RichContent)((Object)this.getElement())).getDocuments().size() > order) {
            Document toRemove = ((RichContent)((Object)this.getElement())).getDocuments().get(order);
            ((RichContent)((Object)this.getElement())).getDocuments().remove(toRemove);
            if (toRemove.getId() != null) {
                this.richContentRepository.update(this.getElement());
            }
        } else {
            this.logger.info((Object)("removeDocument: non posso rimuovere posizione :" + order));
        }
    }

    public void removeImage(Long order) {
        this.removeImage(order.intValue());
    }

    public void removeImage(Integer order) {
        if (order != null && order > 0 && this.getElement() != null && ((RichContent)((Object)this.getElement())).getImages() != null && ((RichContent)((Object)this.getElement())).getImages().size() > 0 && ((RichContent)((Object)this.getElement())).getImages().size() > order) {
            Image toRemove = ((RichContent)((Object)this.getElement())).getImages().get(order);
            ((RichContent)((Object)this.getElement())).getImages().remove(toRemove);
            if (toRemove.getId() != null) {
                this.richContentRepository.update(this.getElement());
            }
        } else {
            this.logger.info((Object)("removeImage: non posso rimuovere posizione:" + order));
        }
    }

    public String cloneElement() {
        this.viewElement();
        return this.cloneCurrent();
    }

    public String cloneCurrent() {
        String newTitle = "Copia di " + ((RichContent)((Object)this.getElement())).getTitle();
        boolean cloneOk = this.cloneCurrent(newTitle);
        return cloneOk ? this.modCurrent() : null;
    }

    private boolean cloneCurrent(String newTitle) {
        RichContent original = (RichContent)((Object)this.getElement());
        this.addElement();
        ((RichContent)((Object)this.getElement())).setAuthor(original.getAuthor());
        ((RichContent)((Object)this.getElement())).setClone(original.isClone());
        ((RichContent)((Object)this.getElement())).setContent(original.getContent());
        ((RichContent)((Object)this.getElement())).setDate(original.getDate());
        ((RichContent)((Object)this.getElement())).setDescription(original.getDescription());
        ((RichContent)((Object)this.getElement())).setExtended(original.isExtended());
        ((RichContent)((Object)this.getElement())).setExtension(original.getExtension());
        ((RichContent)((Object)this.getElement())).setHighlight(((RichContent)((Object)this.getElement())).isHighlight());
        ((RichContent)((Object)this.getElement())).setFormerTitle(null);
        ((RichContent)((Object)this.getElement())).setId(null);
        ((RichContent)((Object)this.getElement())).setPreview(original.getPreview());
        ((RichContent)((Object)this.getElement())).setRichContentType(original.getRichContentType());
        ((RichContent)((Object)this.getElement())).setTags(original.getTags());
        ((RichContent)((Object)this.getElement())).setTemplate(original.getTemplate());
        ((RichContent)((Object)this.getElement())).setTemplateId(original.getTemplateId());
        ((RichContent)((Object)this.getElement())).setTitle(newTitle);
        if (this.save() == null) {
            super.addFacesMessage("Errori durante la copia dei dati.");
            return false;
        }
        List<Document> documents = original.getDocuments();
        List<Image> images = original.getImages();
        int lang = original.getLang();
        for (Document document : documents) {
            document.setId(null);
            ((RichContent)((Object)this.getElement())).addDocument(document);
        }
        for (Image image : images) {
            image.setId(null);
            ((RichContent)((Object)this.getElement())).addImage(image);
        }
        switch (lang) {
            case 1: {
                ((RichContent)((Object)this.getElement())).setLang1id(((RichContent)((Object)this.getElement())).getId());
                break;
            }
            case 2: {
                ((RichContent)((Object)this.getElement())).setLang2id(((RichContent)((Object)this.getElement())).getId());
                break;
            }
            case 3: {
                ((RichContent)((Object)this.getElement())).setLang3id(((RichContent)((Object)this.getElement())).getId());
                break;
            }
            case 4: {
                ((RichContent)((Object)this.getElement())).setLang4id(((RichContent)((Object)this.getElement())).getId());
                break;
            }
            case 5: {
                ((RichContent)((Object)this.getElement())).setLang5id(((RichContent)((Object)this.getElement())).getId());
                break;
            }
        }
        return this.update() != null;
    }

    public String save() {
        RichContentType richContentType = (RichContentType)this.richContentTypeRepository.find(((RichContent)((Object)this.getElement())).getRichContentType().getId());
        ((RichContent)((Object)this.getElement())).setTemplateId(richContentType.getPage().getTemplate().getId());
        if (super.save() == null) {
            return null;
        }
        this.tagRepository.set(((RichContent)((Object)this.getElement())).getId(), ((RichContent)((Object)this.getElement())).getTagList(), ((RichContent)((Object)this.getElement())).getDate());
        this.tags = null;
        if (((RichContent)((Object)this.getElement())).isHighlight()) {
            this.richContentRepository.refreshEvidenza(((RichContent)((Object)this.getElement())).getId());
        }
        return super.viewPage();
    }

    public String update() {
        if (((RichContent)((Object)this.getElement())).getFormerTitle() != null && !((RichContent)((Object)this.getElement())).getFormerTitle().equals(((RichContent)((Object)this.getElement())).getTitle())) {
            RichContent toDelete = (RichContent)((Object)this.getElement());
            boolean cloneOk = this.cloneCurrent(((RichContent)((Object)this.getElement())).getTitle());
            if (cloneOk) {
                this.getRepository().delete((Object)toDelete.getId());
                this.tagRepository.set(toDelete.getId(), new ArrayList<String>(), new Date());
                return this.viewCurrent();
            }
            return null;
        }
        RichContentType richContentType = (RichContentType)this.richContentTypeRepository.find(((RichContent)((Object)this.getElement())).getRichContentType().getId());
        ((RichContent)((Object)this.getElement())).setTemplateId(richContentType.getPage().getTemplateId());
        if (super.update() == null) {
            return null;
        }
        this.tagRepository.set(((RichContent)((Object)this.getElement())).getId(), ((RichContent)((Object)this.getElement())).getTagList(), ((RichContent)((Object)this.getElement())).getDate());
        this.tags = null;
        if (((RichContent)((Object)this.getElement())).isHighlight()) {
            this.richContentRepository.refreshEvidenza(((RichContent)((Object)this.getElement())).getId());
        }
        return super.viewPage();
    }

    public String modDocumentsCurrent() {
        super.modCurrent();
        return EDIT_DOCS + "?faces-redirect=true";
    }

    public String modDocuments() {
        super.modElement();
        return EDIT_DOCS + "?faces-redirect=true";
    }

    public void filterTag(String tagName) {
        ((RichContent)((Object)this.getSearch().getObj())).setTag(tagName);
        this.refreshModel();
    }

    @Produces
    @Named
    public List<Group<Tag>> getTags() {
        if (this.tags == null) {
            Search st = new Search(Tag.class);
            st.setGrouping("tagName");
            ((Tag)st.getObj()).setRichContent((RichContent)((Object)this.getSearch().getObj()));
            this.tags = this.tagRepository.getGroups(st, 0, 50);
        }
        return this.tags;
    }

    public String reload() {
        this.tags = null;
        return super.reload();
    }

    public String reset() {
        this.tags = null;
        return super.reset();
    }

    public String delete() {
        String outcome = super.delete();
        if (outcome != null) {
            this.tagRepository.set(((RichContent)((Object)this.getElement())).getId(), new ArrayList<String>(), new Date());
        }
        return outcome;
    }

    public String saveAndModDocuments() {
        String outcome = this.save();
        if (outcome == null) {
            return null;
        }
        return this.modDocumentsCurrent();
    }

    public void chooseImg() {
        ((Resource)this.resourceController.getSearch().getObj()).setResourceType(ResourceType.IMAGE);
        this.resourceController.reload();
    }

    public void chooseDoc() {
        ((Resource)this.resourceController.getSearch().getObj()).setResourceType(ResourceType.DOCUMENT);
        this.resourceController.reload();
    }

    public String pickResource() {
        this.resourceController.modElement();
        Resource resource = (Resource)this.resourceController.getElement();
        switch (resource.getResourceType()) {
            case IMAGE: {
                byte[] imgRes = resource.getBytes();
                Image img = new Image();
                img.setData(imgRes);
                img.setType(MimeUtils.getContentType((String)resource.getName()));
                img.setFilename(resource.getName());
                ((RichContent)((Object)this.getElement())).getImages().add(img);
                break;
            }
            case DOCUMENT: {
                byte[] docRes = resource.getBytes();
                Document doc = new Document();
                doc.setData(docRes);
                doc.setType(MimeUtils.getContentType((String)resource.getName()));
                doc.setFilename(resource.getName());
                ((RichContent)((Object)this.getElement())).getDocuments().add(doc);
                break;
            }
        }
        return "";
    }
}

