/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.richcontent.controller;

import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.event.LanguageEvent;
import org.giavacms.base.event.PageEvent;
import org.giavacms.base.model.Page;
import org.giavacms.base.repository.PageRepository;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.common.controller.AbstractLazyController;
import org.giavacms.common.event.ResetEvent;
import org.giavacms.common.model.Search;
import org.giavacms.richcontent.model.RichContent;
import org.giavacms.richcontent.model.type.RichContentType;
import org.giavacms.richcontent.repository.RichContentRepository;
import org.giavacms.richcontent.repository.RichContentTypeRepository;
import org.primefaces.event.RowEditEvent;

@Named
@SessionScoped
public class RichContentTypeController
extends AbstractLazyController<RichContentType> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    @ListPage
    @EditPage
    public static String LIST = "/private/richcontent/richcontenttype/list.xhtml";
    @Inject
    @OwnRepository(value=RichContentTypeRepository.class)
    RichContentTypeRepository richContentTypeRepository;
    @Inject
    Event<LanguageEvent> languageEvent;
    @Inject
    Event<PageEvent> pageEvent;
    @Inject
    Event<ResetEvent> resetEvent;
    @Inject
    PageRepository pageRepository;
    @Inject
    RichContentRepository richContentRepository;

    public void initController() {
        this.addElement();
    }

    public String addElement() {
        super.addElement();
        this.getElement().setPage(new Page());
        return null;
    }

    public String reset() {
        this.addElement();
        return super.reset();
    }

    public String save() {
        this.getElement().setPage(this.pageRepository.find((Object)this.getElement().getPage().getId()));
        super.save();
        if (this.getElement().getPage().getLang() > 0) {
            this.languageEvent.fire((Object)new LanguageEvent(this.getElement().getPage().getTemplateId(), this.getElement().getPage().getLang(), true));
        }
        this.updateBasePages(this.getElement());
        this.resetEvent.fire((Object)new ResetEvent(RichContentType.class));
        this.addElement();
        return super.viewPage();
    }

    public String update() {
        super.update();
        if (this.getElement().getPage().getLang() > 0) {
            this.languageEvent.fire((Object)new LanguageEvent(this.getElement().getPage().getTemplateId(), this.getElement().getPage().getLang(), true));
        }
        this.updateBasePages(this.getElement());
        this.resetEvent.fire((Object)new ResetEvent(RichContentType.class));
        return super.viewPage();
    }

    public void onRowEdit(RowEditEvent ree) {
        RichContentType t = (RichContentType)ree.getObject();
        t.setPage(this.pageRepository.find((Object)t.getPage().getId()));
        this.getRepository().update((Object)t);
        if (t.getPage().getLang() > 0) {
            this.languageEvent.fire((Object)new LanguageEvent(t.getPage().getTemplateId(), t.getPage().getLang(), true));
        }
        this.updateBasePages(t);
        this.resetEvent.fire((Object)new ResetEvent(RichContentType.class));
    }

    private void updateBasePages(RichContentType t) {
        Search sr = new Search(RichContent.class);
        ((RichContent)((Object)sr.getObj())).setRichContentType(t);
        for (RichContent r : this.richContentRepository.getList(sr, 0, 0)) {
            r.setTemplateId(t.getPage().getTemplateId());
            this.richContentRepository.update((Object)r);
            this.pageEvent.fire((Object)new PageEvent((Page)r));
            if (t.getPage().getLang() <= 0) continue;
            this.pageRepository.updateLanguage(t.getPage().getLang(), r.getId());
        }
    }

    public RichContentType getElement() {
        if (super.getElement() == null) {
            this.setElement(new RichContentType());
        }
        return (RichContentType)super.getElement();
    }

    public Object getId(RichContentType t) {
        return t.getId();
    }

    public void deleteInline() {
        super.deleteInline();
        this.resetEvent.fire((Object)new ResetEvent(RichContentType.class));
    }

    public String getExtension() {
        return "RichContent";
    }
}

