/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.richcontent.controller.request;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.controller.AbstractPageRequestController;
import org.giavacms.base.pojo.I18nRequestParams;
import org.giavacms.common.annotation.HttpParam;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.model.Group;
import org.giavacms.common.model.Search;
import org.giavacms.richcontent.model.RichContent;
import org.giavacms.richcontent.model.Tag;
import org.giavacms.richcontent.model.type.RichContentType;
import org.giavacms.richcontent.repository.RichContentRepository;
import org.giavacms.richcontent.repository.RichContentTypeRepository;
import org.giavacms.richcontent.repository.TagRepository;

@Named
@RequestScoped
public class RichContentRequestController
extends AbstractPageRequestController<RichContent>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CURRENT_PAGE_PARAM = "p";
    public static final String ID_PARAM = "id";
    @Inject
    @HttpParam(value="q")
    String content;
    @Inject
    @HttpParam(value="t")
    String type;
    @Inject
    @HttpParam(value="tag")
    String tag;
    @Inject
    @HttpParam(value="id")
    String id;
    @Inject
    @HttpParam(value="p")
    String start;
    @Inject
    @OwnRepository(value=RichContentRepository.class)
    RichContentRepository richContentRepository;
    @Inject
    RichContentTypeRepository richContentTypeRepository;
    private RichContent last;
    List<Group<Tag>> requestTags;
    @Inject
    TagRepository tagRepository;

    public List<String> getTipiRichContent() {
        Search r = new Search(RichContentType.class);
        List rntl = this.richContentTypeRepository.getList(r, 0, 0);
        ArrayList<String> l = new ArrayList<String>();
        for (RichContentType rnt : rntl) {
            l.add(rnt.getName());
        }
        return l;
    }

    protected void initSearch() {
        ((RichContent)((Object)this.getSearch().getObj())).setTag(this.tag);
        ((RichContent)((Object)this.getSearch().getObj())).setTitle(this.content);
        ((RichContent)((Object)this.getSearch().getObj())).getRichContentType().setName(this.type);
        super.initSearch();
    }

    public String getCurrentPageParam() {
        return CURRENT_PAGE_PARAM;
    }

    public boolean isScheda() {
        return this.getElement() != null && ((RichContent)((Object)this.getElement())).getId() != null;
    }

    public RichContent getLast(String category) {
        if (this.last == null) {
            RichContent last;
            this.last = last = this.richContentRepository.getLast(category);
        }
        return this.last;
    }

    protected void handleI18N() {
        int currentLang;
        String testValue;
        String testName = "test";
        I18nRequestParams i18nRequestParams = super.getI18nRequestParams();
        if (this.getBasePage() != null && (testValue = i18nRequestParams.get(currentLang = this.getBasePage().getLang(), testName)) != null && testValue.trim().length() > 0) {
            for (int i = 0; i < i18nRequestParams.getLanguages().length; ++i) {
                if (i == currentLang) continue;
                i18nRequestParams.put(i, testName, i18nRequestParams.getLanguages()[i] == null || !i18nRequestParams.getLanguages()[i].isEnabled() ? "UNSUPPORTED" : testValue + "_" + i18nRequestParams.getLanguages()[i].getId());
            }
        }
    }

    @Produces
    @Named
    public List<Group<Tag>> getRequestTags() {
        if (this.requestTags == null) {
            Search st = new Search(Tag.class);
            st.setGrouping("tagName");
            ((Tag)st.getObj()).setRichContent(new RichContent());
            ((Tag)st.getObj()).getRichContent().setRichContentType(((RichContent)((Object)this.getSearch().getObj())).getRichContentType());
            this.requestTags = this.tagRepository.getGroups(st, 0, 10);
        }
        return this.requestTags == null ? new ArrayList() : this.requestTags;
    }
}

