/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.richcontent.repository;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Named;
import org.giavacms.base.common.util.HtmlUtils;
import org.giavacms.base.controller.util.TimeUtils;
import org.giavacms.base.model.Page;
import org.giavacms.base.model.attachment.Document;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.base.repository.AbstractPageRepository;
import org.giavacms.common.model.Search;
import org.giavacms.common.util.StringUtils;
import org.giavacms.richcontent.model.RichContent;
import org.giavacms.richcontent.model.type.RichContentType;

@Named
@Stateless
@LocalBean
public class RichContentRepository
extends AbstractPageRepository<RichContent> {
    private static final long serialVersionUID = 1L;

    protected RichContent prePersist(RichContent n) {
        n.setClone(true);
        if (n.getDate() == null) {
            n.setDate(new Date());
        }
        if (n.getRichContentType() != null && n.getRichContentType().getId() != null) {
            n.setRichContentType((RichContentType)this.getEm().find(RichContentType.class, (Object)n.getRichContentType().getId()));
        }
        if (n.getDocuments() != null && n.getDocuments().size() == 0) {
            n.setDocuments(null);
        }
        if (n.getImages() != null && n.getImages().size() == 0) {
            n.setImages(null);
        }
        n.setDate(TimeUtils.adjustHourAndMinute((Date)n.getDate()));
        n.setContent(HtmlUtils.normalizeHtml((String)n.getContent()));
        return (RichContent)super.prePersist((Page)n);
    }

    protected RichContent preUpdate(RichContent n) {
        n.setClone(true);
        if (n.getDate() == null) {
            n.setDate(new Date());
        }
        if (n.getRichContentType() != null && n.getRichContentType().getId() != null) {
            n.setRichContentType((RichContentType)this.getEm().find(RichContentType.class, (Object)n.getRichContentType().getId()));
        }
        if (n.getDocuments() != null && n.getDocuments().size() == 0) {
            n.setDocuments(null);
        }
        if (n.getImages() != null && n.getImages().size() == 0) {
            n.setImages(null);
        }
        n.setDate(TimeUtils.adjustHourAndMinute((Date)n.getDate()));
        n.setContent(HtmlUtils.normalizeHtml((String)n.getContent()));
        n = (RichContent)super.preUpdate((Page)n);
        return n;
    }

    public RichContent findLast() {
        RichContent ret = new RichContent();
        try {
            ret = (RichContent)((Object)this.getEm().createQuery("select p from " + RichContent.class.getSimpleName() + " p order by p.date desc ").setMaxResults(1).getSingleResult());
            if (ret == null) {
                return null;
            }
            return (RichContent)this.fetch(ret.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
    }

    public RichContent getLast(String category) {
        Search r = new Search(RichContent.class);
        ((RichContent)((Object)r.getObj())).getRichContentType().setName(category);
        List list = this.getList(r, 0, 1);
        return list.size() > 0 ? (RichContent)((Object)list.get(0)) : new RichContent();
    }

    public RichContent findHighlight() {
        try {
            String retId = (String)this.getEm().createQuery("select p.id from " + RichContent.class.getSimpleName() + " p where p.highlight = :STATUS ").setParameter("STATUS", (Object)true).setMaxResults(1).getSingleResult();
            return (RichContent)this.fetch(retId);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return this.findLast();
        }
    }

    public void refreshEvidenza(String id) {
        List ret = null;
        try {
            ret = this.getEm().createQuery("select p from " + RichContent.class.getSimpleName() + " p where p.id != :ID AND p.highlight = :STATUS").setParameter("ID", (Object)id).setParameter("STATUS", (Object)true).getResultList();
            if (ret != null) {
                for (RichContent richContent : ret) {
                    richContent.setHighlight(false);
                    this.update((Object)richContent);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Image findHighlightImage() {
        try {
            List nl = this.getEm().createQuery("select p from " + RichContent.class.getSimpleName() + " p where p.highlight = :STATUS").setParameter("STATUS", (Object)true).getResultList();
            if (nl == null || nl.size() == 0 || ((RichContent)((Object)nl.get(0))).getImages() == null || ((RichContent)((Object)nl.get(0))).getImages().size() == 0) {
                return null;
            }
            return ((RichContent)((Object)nl.get(0))).getImages().get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getDefaultOrderBy() {
        return "date desc";
    }

    protected StringBuffer getListNative(Search<RichContent> search, Map<String, Object> params, boolean count, int startRow, int pageSize, boolean completeFetch) {
        String pageAlias = "P";
        String templateImplAlias = "T";
        String richContentAlias = "R";
        String richContentTypeAlias = "RT";
        String imageAlias = "I";
        String documentAlias = "D";
        StringBuffer sb = new StringBuffer("SELECT ");
        if (count) {
            sb.append(" count( distinct ").append(pageAlias).append(".id ) ");
        } else {
            sb.append(pageAlias).append(".id, ");
            sb.append(pageAlias).append(".lang1id, ");
            sb.append(pageAlias).append(".lang2id, ");
            sb.append(pageAlias).append(".lang3id, ");
            sb.append(pageAlias).append(".lang4id, ");
            sb.append(pageAlias).append(".lang5id, ");
            sb.append(pageAlias).append(".clone, ");
            sb.append(pageAlias).append(".title, ");
            sb.append(pageAlias).append(".description, ");
            sb.append(templateImplAlias).append(".id as templateImpl_id, ");
            sb.append(templateImplAlias).append(".mainPageId, ");
            sb.append(templateImplAlias).append(".mainPageTitle, ");
            sb.append(richContentAlias).append(".author, ");
            sb.append(richContentAlias).append(".content, ");
            sb.append(richContentAlias).append(".date, ");
            sb.append(richContentAlias).append(".highlight, ");
            sb.append(richContentAlias).append(".preview, ");
            sb.append(richContentAlias).append(".tags,  ");
            sb.append(richContentAlias).append(".richContentType_id, ");
            sb.append(richContentTypeAlias).append(".name AS richContentType, ");
            sb.append(imageAlias).append(".id AS imageId, ");
            sb.append(imageAlias).append(".fileName AS image,");
            sb.append(documentAlias).append(".id AS documentId, ");
            sb.append(documentAlias).append(".fileName AS document ");
            if (completeFetch) {
                // empty if block
            }
        }
        sb.append(" FROM ").append("RichContent").append(" AS ").append(richContentAlias);
        sb.append(" LEFT JOIN ").append("RichContentType").append(" AS ").append(richContentTypeAlias).append(" ON ( ").append(richContentTypeAlias).append(".id = ").append(richContentAlias).append(".richContentType_id ) ");
        sb.append(" LEFT JOIN ").append("Page").append(" as ").append(pageAlias).append(" on ( ").append(richContentAlias).append(".id = ").append(pageAlias).append(".id ) ");
        sb.append(" LEFT JOIN ").append("TemplateImpl").append(" as ").append(templateImplAlias).append(" on ( ").append(templateImplAlias).append(".id = ").append(pageAlias).append(".template_id ) ");
        if (!count) {
            sb.append(" LEFT JOIN ").append("RichContent").append("_").append("Document").append(" AS RD ON ( RD.").append("RichContent").append("_id = ").append(richContentAlias).append(".id ) ");
            sb.append(" LEFT JOIN ").append("Document").append(" AS ").append(documentAlias).append(" ON ( RD.documents_id = ").append(documentAlias).append(".id ) ");
            sb.append(" LEFT JOIN ").append("RichContent").append("_").append("Image").append(" AS RI ON ( RI.").append("RichContent").append("_id = ").append(richContentAlias).append(".id ) ");
            sb.append(" LEFT JOIN ").append("Image").append(" as ").append(imageAlias).append(" on ( ").append(imageAlias).append(".id = RI.images_id ) ");
        }
        String innerPageAlias = null;
        String innerTemplateImplAlias = null;
        String innerRichContentAlias = null;
        String innerRichContentTypeAlias = null;
        if (count) {
            innerPageAlias = pageAlias;
            innerTemplateImplAlias = templateImplAlias;
            innerRichContentAlias = richContentAlias;
            innerRichContentTypeAlias = richContentTypeAlias;
        } else {
            innerPageAlias = "P1";
            innerTemplateImplAlias = "T1";
            innerRichContentAlias = "R1";
            innerRichContentTypeAlias = "RT1";
            sb.append(" INNER JOIN ");
            sb.append(" ( ");
            sb.append(" select distinct ").append(innerPageAlias).append(".id from ");
            sb.append("RichContent").append(" AS ").append(innerRichContentAlias);
            sb.append(" LEFT JOIN ").append("RichContentType").append(" AS ").append(innerRichContentTypeAlias).append(" ON ( ").append(innerRichContentTypeAlias).append(".id = ").append(innerRichContentAlias).append(".richContentType_id ) ");
            sb.append(" LEFT JOIN ").append("Page").append(" as ").append(innerPageAlias).append(" on ( ").append(innerRichContentAlias).append(".id = ").append(innerPageAlias).append(".id ) ");
            sb.append(" LEFT JOIN ").append("TemplateImpl").append(" as ").append(innerTemplateImplAlias).append(" on ( ").append(innerTemplateImplAlias).append(".id = ").append(innerPageAlias).append(".template_id ) ");
        }
        String separator = " where ";
        this.applyRestrictionsNative(search, innerPageAlias, innerTemplateImplAlias, innerRichContentAlias, innerRichContentTypeAlias, separator, sb, params);
        if (!count) {
            sb.append(" order by ").append(innerRichContentAlias).append(".date desc ");
            if (pageSize > 0) {
                sb.append(" limit ").append(startRow).append(", ").append(pageSize).toString();
            }
            sb.append(" ) ");
            sb.append(" as IN2 ON ").append(pageAlias).append(".ID = IN2.ID ");
            sb.append(" order by ").append(richContentAlias).append(".date desc ");
            sb.append(", ").append(imageAlias).append(".id asc ");
            sb.append(", ").append(documentAlias).append(".id asc ");
        }
        return sb;
    }

    protected void applyRestrictionsNative(Search<RichContent> search, String pageAlias, String templateImplAlias, String richContentAlias, String richContentTypeAlias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(richContentTypeAlias).append(".active = :activeContentType ");
        params.put("activeContentType", true);
        separator = " and ";
        if (search.getFrom() != null && ((RichContent)((Object)search.getFrom())).getDate() != null) {
            sb.append(separator).append(richContentTypeAlias).append(".date >= :FROMDATE ");
            params.put("FROMDATE", ((RichContent)((Object)search.getFrom())).getDate());
            separator = " and ";
        }
        if (search.getTo() != null && ((RichContent)((Object)search.getTo())).getDate() != null) {
            sb.append(separator).append(richContentTypeAlias).append(".date <= :TODATE ");
            params.put("TODATE", ((RichContent)((Object)search.getTo())).getDate());
            separator = " and ";
        }
        if (((RichContent)((Object)search.getObj())).getRichContentType() != null && ((RichContent)((Object)search.getObj())).getRichContentType().getName() != null && ((RichContent)((Object)search.getObj())).getRichContentType().getName().length() > 0) {
            if (((RichContent)((Object)search.getObj())).getRichContentType().getName().contains(",")) {
                String[] names = ((RichContent)((Object)search.getObj())).getRichContentType().getName().split(",");
                StringBuffer orBuffer = new StringBuffer();
                String orSeparator = "";
                for (int i = 0; i < names.length; ++i) {
                    if (names[i].trim().length() <= 0) continue;
                    orBuffer.append(orSeparator).append(richContentTypeAlias).append(".name = :NAMETYPE" + i + " ");
                    params.put("NAMETYPE" + i, names[i].trim());
                    orSeparator = " or ";
                }
                if (orBuffer.length() > 0) {
                    sb.append(separator).append(" ( ").append(orBuffer).append(" ) ");
                    separator = " and ";
                }
            } else {
                sb.append(separator).append(richContentTypeAlias).append(".name = :NAMETYPE ");
                params.put("NAMETYPE", ((RichContent)((Object)search.getObj())).getRichContentType().getName());
                separator = " and ";
            }
        }
        if (((RichContent)((Object)search.getObj())).getRichContentType() != null && ((RichContent)((Object)search.getObj())).getRichContentType().getId() != null) {
            sb.append(separator).append(richContentTypeAlias).append(".id = :IDTYPE ");
            params.put("IDTYPE", ((RichContent)((Object)search.getObj())).getRichContentType().getId());
            separator = " and ";
        }
        if (((RichContent)((Object)search.getObj())).getTag() != null && ((RichContent)((Object)search.getObj())).getTag().trim().length() > 0) {
            String tagName = ((RichContent)((Object)search.getObj())).getTag().trim();
            String tagNameCleaned = StringUtils.clean((String)((RichContent)((Object)search.getObj())).getTag().trim()).replace('-', ' ');
            Boolean likeMatch = null;
            likeMatch = !tagName.equals(tagNameCleaned) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            sb.append(separator).append(richContentAlias).append(".id in ( ");
            sb.append(" select distinct T1.richContent_id from ").append("Tag").append(" T1 where T1.tagName ").append(likeMatch != false ? "like" : "=").append(" :TAGNAME ");
            sb.append(" ) ");
            params.put("TAGNAME", likeMatch != false ? this.likeParam(tagNameCleaned) : tagName);
            separator = " and ";
        }
        if (((RichContent)((Object)search.getObj())).getTagList().size() > 0) {
            sb.append(separator).append(" ( ");
            for (int i = 0; i < ((RichContent)((Object)search.getObj())).getTagList().size(); ++i) {
                sb.append(i > 0 ? " or " : "");
                boolean useJoin = false;
                if (useJoin) {
                    sb.append(richContentAlias).append(".id in ( ");
                    sb.append(" select distinct T2.richContent_id from ").append("Tag").append(" T2 where upper ( T2.tagName ) like :TAGNAME").append(i).append(" ");
                    sb.append(" ) ");
                } else {
                    sb.append(" upper ( ").append(richContentAlias).append(".tags ) like :TAGNAME").append(i).append(" ");
                }
                params.put("TAGNAME" + i, this.likeParam(((RichContent)((Object)search.getObj())).getTagList().get(i).trim().toUpperCase()));
            }
            sb.append(" ) ");
            separator = " and ";
        }
        String customLike = null;
        if (((RichContent)((Object)search.getObj())).getTitle() != null && !((RichContent)((Object)search.getObj())).getTitle().trim().isEmpty()) {
            customLike = "upper ( " + richContentAlias + ".content ) like :LIKETEXTCUSTOM ";
            params.put("LIKETEXTCUSTOM", this.likeParam(((RichContent)((Object)search.getObj())).getTitle().trim().toUpperCase()));
        }
        super.applyRestrictionsNative(search, pageAlias, separator, sb, params, customLike);
    }

    protected List<RichContent> extract(List resultList, boolean completeFetch) {
        RichContent rich;
        RichContent richContent = null;
        LinkedHashMap images = new LinkedHashMap();
        LinkedHashMap documents = new LinkedHashMap();
        LinkedHashMap<String, RichContent> richContents = new LinkedHashMap<String, RichContent>();
        Iterator results = resultList.iterator();
        while (results.hasNext()) {
            Object documentId;
            Object imageId;
            Object hightlight;
            richContent = new RichContent();
            Object[] row = (Object[])results.next();
            int i = 0;
            String id = (String)row[i];
            richContent.setId(id);
            String lang1id = (String)row[++i];
            richContent.setLang1id(lang1id);
            String lang2id = (String)row[++i];
            richContent.setLang2id(lang2id);
            String lang3id = (String)row[++i];
            richContent.setLang3id(lang3id);
            String lang4id = (String)row[++i];
            richContent.setLang4id(lang4id);
            String lang5id = (String)row[++i];
            richContent.setLang5id(lang5id);
            Object clone = row[++i];
            if (clone != null) {
                if (clone instanceof Boolean) {
                    richContent.setClone((Boolean)clone);
                }
                if (clone instanceof Short) {
                    richContent.setClone(((Short)clone).intValue() > 0);
                } else {
                    logger.error((Object)("clone instance of " + clone.getClass().getCanonicalName()));
                }
            } else {
                logger.error((Object)"clone should not be null");
            }
            String title = (String)row[++i];
            richContent.setTitle(title);
            String description = (String)row[++i];
            richContent.setDescription(description);
            Object template_impl_id = row[++i];
            if (template_impl_id != null) {
                if (template_impl_id instanceof BigInteger) {
                    richContent.getTemplate().setId(Long.valueOf(((BigInteger)template_impl_id).longValue()));
                    richContent.setTemplateId(((BigInteger)template_impl_id).longValue());
                } else {
                    logger.error((Object)("templateImpl_id instance of " + template_impl_id.getClass().getCanonicalName()));
                }
            } else {
                logger.error((Object)"templateImpl_id should not be null");
            }
            String mainPageId = (String)row[++i];
            richContent.getTemplate().setMainPageId(mainPageId);
            String mainPageTitle = (String)row[++i];
            richContent.getTemplate().setMainPageTitle(mainPageTitle);
            String author = (String)row[++i];
            richContent.setAuthor(author);
            String content = (String)row[++i];
            richContent.setContent(content);
            Timestamp date = (Timestamp)row[++i];
            if (date != null) {
                richContent.setDate(new Date(date.getTime()));
            }
            if ((hightlight = row[++i]) != null) {
                if (hightlight instanceof Short) {
                    richContent.setHighlight((Short)hightlight > 0);
                } else if (hightlight instanceof Boolean) {
                    richContent.setHighlight((Boolean)hightlight);
                } else {
                    logger.error((Object)("hightlight instance of " + hightlight.getClass().getCanonicalName()));
                }
            }
            String preview = (String)row[++i];
            richContent.setPreview(preview);
            String tags = (String)row[++i];
            richContent.setTags(tags);
            Object richContentType_id = row[++i];
            if (richContentType_id != null) {
                if (richContentType_id instanceof BigInteger) {
                    richContent.getRichContentType().setId(((BigInteger)richContentType_id).longValue());
                } else {
                    logger.error((Object)("richContentType_id instance of " + richContentType_id.getClass().getCanonicalName()));
                }
            } else {
                logger.error((Object)"richContentType_id should not be null");
            }
            String richContentType = (String)row[++i];
            if (richContentType != null && !richContentType.isEmpty()) {
                richContent.getRichContentType().setName(richContentType);
            }
            Image image = null;
            if ((imageId = row[++i]) != null) {
                if (imageId instanceof BigInteger) {
                    image = new Image();
                    image.setId(Long.valueOf(((BigInteger)imageId).longValue()));
                } else {
                    logger.error((Object)("imageId instance of " + imageId.getClass().getCanonicalName()));
                }
            }
            String imagefileName = (String)row[++i];
            if (image != null && imagefileName != null && !imagefileName.isEmpty()) {
                Map<Long, Image> map;
                image.setFilename(imagefileName);
                if (images.containsKey(id)) {
                    map = (Map)images.get(id);
                    map.put(image.getId(), image);
                } else {
                    map = new LinkedHashMap();
                    map.put(image.getId(), image);
                    images.put(id, map);
                }
            }
            Document document = null;
            if ((documentId = row[++i]) != null) {
                if (documentId instanceof BigInteger) {
                    document = new Document();
                    document.setId(Long.valueOf(((BigInteger)documentId).longValue()));
                } else {
                    logger.error((Object)("documentId instance of " + documentId.getClass().getCanonicalName()));
                }
            }
            String documentfileName = (String)row[++i];
            if (document != null && documentfileName != null && !documentfileName.isEmpty()) {
                Map<Long, Document> map;
                document.setFilename(documentfileName);
                if (documents.containsKey(id)) {
                    map = (Map)documents.get(id);
                    map.put(document.getId(), document);
                } else {
                    map = new LinkedHashMap();
                    map.put(document.getId(), document);
                    documents.put(id, map);
                }
            }
            ++i;
            if (completeFetch) {
                // empty if block
            }
            if (richContents.containsKey(id)) continue;
            richContents.put(id, richContent);
        }
        for (String id : documents.keySet()) {
            rich = null;
            if (richContents.containsKey(id)) {
                rich = (RichContent)((Object)richContents.get(id));
                Map docs = (Map)documents.get(id);
                if (docs == null) continue;
                for (Long docId : docs.keySet()) {
                    rich.addDocument((Document)docs.get(docId));
                }
                continue;
            }
            logger.error((Object)("ERROR - DOCS CYCLE cannot find id:" + id));
        }
        for (String id : images.keySet()) {
            rich = null;
            if (richContents.containsKey(id)) {
                rich = (RichContent)((Object)richContents.get(id));
                Map imgs = (Map)images.get(id);
                if (imgs == null) continue;
                for (Long imgId : imgs.keySet()) {
                    rich.addImage((Image)imgs.get(imgId));
                }
                continue;
            }
            logger.error((Object)("ERROR - IMGS CYCLE cannot find id:" + id));
        }
        return new ArrayList<RichContent>(richContents.values());
    }
}

