/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.richcontent.repository;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.giavacms.common.model.Search;
import org.giavacms.common.repository.AbstractRepository;
import org.giavacms.richcontent.model.RichContent;
import org.giavacms.richcontent.model.Tag;

@Named
@Stateless
@LocalBean
public class TagRepository
extends AbstractRepository<Tag> {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    EntityManager em;

    protected EntityManager getEm() {
        return this.em;
    }

    public void setEm(EntityManager em) {
        this.em = em;
    }

    protected String getDefaultOrderBy() {
        return "tagName asc";
    }

    protected void applyRestrictions(Search<Tag> search, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        boolean likeSearch;
        if (((Tag)search.getObj()).getTagName() != null && ((Tag)search.getObj()).getTagName().trim().length() > 0) {
            sb.append(separator).append(" upper ( ").append(alias).append(".tagName ) like :TAGNAME ");
            params.put("TAGNAME", this.likeParam(((Tag)search.getObj()).getTagName().trim().toUpperCase()));
            separator = " and ";
        }
        sb.append(separator).append(alias).append(".richContent.richContentType.active = :activeContentType ");
        params.put("activeContentType", true);
        separator = " and ";
        if (((Tag)search.getObj()).getRichContent() != null && ((Tag)search.getObj()).getRichContent().getRichContentType() != null && ((Tag)search.getObj()).getRichContent().getRichContentType().getName() != null && ((Tag)search.getObj()).getRichContent().getRichContentType().getName().trim().length() > 0) {
            if (((Tag)search.getObj()).getRichContent().getRichContentType().getName().contains(",")) {
                String[] names = ((Tag)search.getObj()).getRichContent().getRichContentType().getName().split(",");
                StringBuffer orBuffer = new StringBuffer();
                String orSeparator = "";
                for (int i = 0; i < names.length; ++i) {
                    if (names[i].trim().length() <= 0) continue;
                    orBuffer.append(orSeparator).append(alias).append(".richContent.richContentType.name = :NAMETYPE" + i + " ");
                    params.put("NAMETYPE" + i, names[i].trim());
                    orSeparator = " or ";
                }
                if (orBuffer.length() > 0) {
                    sb.append(separator).append(" ( ").append(orBuffer).append(" ) ");
                    separator = " and ";
                }
            } else {
                sb.append(separator).append(alias).append(".richContent.richContentType.name = :TYPENAME ");
                params.put("TYPENAME", ((Tag)search.getObj()).getRichContent().getRichContentType().getName().trim());
                separator = " and ";
            }
        }
        if (((Tag)search.getObj()).getRichContent() != null && ((Tag)search.getObj()).getRichContent().getRichContentType() != null && ((Tag)search.getObj()).getRichContent().getRichContentType().getId() != null) {
            sb.append(separator).append(alias).append(".richContent.richContentType.id = :TYPEID ");
            params.put("TYPEID", ((Tag)search.getObj()).getRichContent().getRichContentType().getId());
            separator = " and ";
        }
        sb.append(separator).append(alias).append(".richContent.active = :activeContent ");
        params.put("activeContent", true);
        separator = " and ";
        if (((Tag)search.getObj()).getRichContent() != null && ((Tag)search.getObj()).getRichContent().getTemplate() != null && ((Tag)search.getObj()).getRichContent().getTemplate().getId() != null) {
            sb.append(separator).append(alias).append(".richContent.template.id = :BASEPAGE_TEMPLATE_ID ");
            params.put("BASEPAGE_TEMPLATE_ID", ((Tag)search.getObj()).getRichContent().getTemplate().getId());
            separator = " and ";
        }
        if (((Tag)search.getObj()).getRichContent() != null && ((Tag)search.getObj()).getRichContent().getTitle() != null && !((Tag)search.getObj()).getRichContent().getTitle().trim().isEmpty() && (likeSearch = this.likeSearch(this.likeParam(((Tag)search.getObj()).getRichContent().getTitle().trim().toUpperCase()), alias, separator, sb, params))) {
            separator = " and ";
        }
        if (((Tag)search.getObj()).getRichContent() != null && ((Tag)search.getObj()).getRichContent().getLang() > 0) {
            if (((Tag)search.getObj()).getRichContent().getLang() == 1) {
                sb.append(separator).append(alias).append(".richContent.id = ").append(alias).append("richContent.lang1id ");
            } else if (((Tag)search.getObj()).getRichContent().getLang() == 2) {
                sb.append(separator).append(alias).append(".richContent.id = ").append(alias).append("richContent.lang2id ");
            } else if (((Tag)search.getObj()).getRichContent().getLang() == 3) {
                sb.append(separator).append(alias).append(".richContent.id = ").append(alias).append("richContent.lang3id ");
            } else if (((Tag)search.getObj()).getRichContent().getLang() == 4) {
                sb.append(separator).append(alias).append(".richContent.id = ").append(alias).append("richContent.lang4id ");
            } else if (((Tag)search.getObj()).getRichContent().getLang() == 5) {
                sb.append(separator).append(alias).append(".richContent.id = ").append(alias).append("richContent.lang5id ");
            }
        }
        if (((Tag)search.getObj()).getRichContent() != null && ((Tag)search.getObj()).getRichContent().getId() != null && ((Tag)search.getObj()).getRichContent().getId().trim().length() > 0) {
            sb.append(separator).append(alias).append(".richContent.id = :RICHCONTENTID1 ");
            params.put("RICHCONTENTID1", ((Tag)search.getObj()).getRichContent().getId().trim());
            separator = " and ";
        }
        if (((Tag)search.getObj()).getRichContentId() != null && ((Tag)search.getObj()).getRichContentId().trim().length() > 0) {
            sb.append(separator).append(alias).append(".richContent.id = :RICHCONTENTID2 ");
            params.put("RICHCONTENTID2", ((Tag)search.getObj()).getRichContentId().trim());
            separator = " and ";
        }
        if (((Tag)search.getObj()).getRichContent() != null && ((Tag)search.getObj()).getRichContent().getTag() != null && ((Tag)search.getObj()).getRichContent().getTag().trim().length() > 0) {
            sb.append(separator).append(alias).append(".richContent.id in ( ");
            sb.append(" select distinct rt.richContent.id from ").append(Tag.class.getSimpleName()).append(" rt where rt.tagName = :RICHCONTENTTAGNAME ");
            sb.append(" ) ");
            params.put("RICHCONTENTTAGNAME", ((Tag)search.getObj()).getRichContent().getTag().trim());
            separator = " and ";
        }
        if (((Tag)search.getObj()).getRichContent() != null && ((Tag)search.getObj()).getRichContent().getTagList().size() > 0) {
            sb.append(separator).append(" ( ");
            for (int i = 0; i < ((Tag)search.getObj()).getRichContent().getTagList().size(); ++i) {
                sb.append(i > 0 ? " or " : "");
                boolean usaJoin = false;
                if (usaJoin) {
                    sb.append(alias).append(".richContent.id in ( ");
                    sb.append(" select distinct rt.richContent.id from ").append(Tag.class.getSimpleName()).append(" rt where upper ( rt.tagName ) like :TAGLIKE").append(i).append(" ");
                    sb.append(" ) ");
                } else {
                    sb.append(" upper ( ").append(alias).append(".richContent.tags ) like :TAGLIKE").append(i).append(" ");
                }
                params.put("TAGLIKE" + i, this.likeParam(((Tag)search.getObj()).getRichContent().getTag().trim().toUpperCase()));
            }
            separator = " and ";
        }
        super.applyRestrictions(search, alias, separator, sb, params);
    }

    protected Tag construct(List<String> fieldNames, List<Object> fieldValues) {
        Tag t = new Tag();
        t.setRichContent(new RichContent());
        for (int i = 0; i < fieldNames.size(); ++i) {
            if ("tagName".equals(fieldNames.get(i))) {
                t.setTagName((String)fieldValues.get(i));
                continue;
            }
            if ("day".equals(fieldNames.get(i))) {
                t.setDay((Integer)fieldValues.get(i));
                continue;
            }
            if ("month".equals(fieldNames.get(i))) {
                t.setMonth((Integer)fieldValues.get(i));
                continue;
            }
            if (!"year".equals(fieldNames.get(i))) continue;
            t.setYear((Integer)fieldValues.get(i));
        }
        return t;
    }

    public void set(String richContentId, List<String> tagList, Date date) {
        this.getEm().createQuery("delete from " + Tag.class.getSimpleName() + " t where t.richContentId = :RICHCONTENTID ").setParameter("RICHCONTENTID", (Object)richContentId).executeUpdate();
        if (date == null) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int day = cal.get(5);
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        for (String tagName : tagList) {
            this.getEm().persist((Object)new Tag(tagName, richContentId, day, month, year));
        }
    }

    protected boolean likeSearch(String likeText, String alias, String separator, StringBuffer sb, Map<String, Object> params) {
        sb.append(separator).append(" upper ( ").append(alias).append(".richContent.title ) like :title ");
        params.put("title", likeText);
        return true;
    }
}

