/*
 * Decompiled with CFR 0.152.
 */
package org.gittorr.ccerial;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gittorr.ccerial.Serializer;

public final class Ccerial {
    private static final Map<Class<?>, Serializer<?>> serializersCache = new ConcurrentHashMap();

    public static <E> Serializer<E> getSerializer(Class<E> forClass) {
        Serializer serializer = serializersCache.get(forClass);
        if (serializer != null) {
            return serializer;
        }
        String originalClassName = forClass.getName();
        String serializerClassName = "ccerial." + originalClassName + "_CcerialSerializer";
        try {
            Class<?> serializerClass = Class.forName(serializerClassName);
            try {
                serializer = (Serializer)serializerClass.getField("INSTANCE").get(null);
            }
            catch (NoSuchFieldException e) {
                serializer = (Serializer)serializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            serializersCache.put(forClass, serializer);
            return serializer;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Serializer class not found for " + originalClassName, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate serializer for " + originalClassName, e);
        }
    }
}

