/*
 * Decompiled with CFR 0.152.
 */
package org.gittorr.ccerial.utils;

import java.util.HashMap;
import java.util.Map;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.gittorr.ccerial.utils.FieldAccessorWriter;
import org.gittorr.ccerial.utils.impl.ArrayFieldAccessorWriter;
import org.gittorr.ccerial.utils.impl.ObjectArrayFieldAccessorWriter;
import org.gittorr.ccerial.utils.impl.SimpleFieldAccessorWriter;

public final class FieldAccessorWriterManager {
    private static final Map<FieldAccessorWriter, FieldAccessorWriter> ACCESSORS = new HashMap<FieldAccessorWriter, FieldAccessorWriter>();
    private static Types typeUtils;

    private static void addAccessor(FieldAccessorWriter acc) {
        ACCESSORS.put(acc, acc);
    }

    public static void setTypeUtils(Types typeUtils) {
        FieldAccessorWriterManager.typeUtils = typeUtils;
    }

    public static boolean isWrapperType(TypeMirror typeMirror) {
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return false;
        }
        try {
            return typeMirror.toString().equals("java.lang.String") || typeUtils.unboxedType(typeMirror) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static FieldAccessorWriter getFieldAccessorWriter(TypeMirror type, boolean variable) {
        ArrayType at;
        TypeMirror componentType;
        TypeKind kind = type.getKind();
        String typeName = null;
        typeName = kind == TypeKind.ARRAY ? ((componentType = (at = (ArrayType)type).getComponentType()).getKind().isPrimitive() ? at.toString() : (FieldAccessorWriterManager.isWrapperType(componentType) ? componentType.toString() : "java.lang.Object")) : type.toString();
        return ACCESSORS.get(new SimpleFieldAccessorWriter(kind, variable, typeName, null, null));
    }

    static {
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.BYTE, false, "byte", "writeByte", "readByte"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.BYTE, true, "byte", "writeByte", "readByte"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.SHORT, false, "short", "writeShort", "readShort"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.SHORT, true, "short", "writeShort", "readShort"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.CHAR, false, "char", "writeChar", "readChar"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.CHAR, true, "char", "writeChar", "readChar"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.INT, false, "int", "writeInt", "readInt"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.INT, true, "int", "writeVarInt", "readVarInt"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.FLOAT, false, "float", "writeFloat", "readFloat"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.FLOAT, true, "float", "writeVarFloat", "readVarFloat"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DOUBLE, false, "double", "writeDouble", "readDouble"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DOUBLE, true, "double", "writeVarDouble", "readVarDouble"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.BOOLEAN, false, "boolean", "writeBoolean", "readBoolean"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.BOOLEAN, true, "boolean", "writeBoolean", "readBoolean"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DECLARED, false, "java.lang.Boolean", "writeBoolean", "readBoolean"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DECLARED, true, "java.lang.Boolean", "writeBoolean", "readBoolean"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DECLARED, false, "java.lang.Byte", "writeByte", "readByte"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DECLARED, true, "java.lang.Byte", "writeByte", "readByte"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DECLARED, false, "java.lang.Short", "writeShort", "readShort"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DECLARED, true, "java.lang.Short", "writeShort", "readShort"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DECLARED, false, "java.lang.Character", "writeChar", "readChar"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DECLARED, true, "java.lang.Character", "writeChar", "readChar"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DECLARED, false, "java.lang.Integer", "writeInt", "readInt"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DECLARED, true, "java.lang.Integer", "writeVarInt", "readVarInt"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DECLARED, false, "java.lang.Float", "writeFloat", "readFloat"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DECLARED, true, "java.lang.Float", "writeFloat", "readFloat"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DECLARED, false, "java.lang.Double", "writeDouble", "readDouble"));
        FieldAccessorWriterManager.addAccessor(new SimpleFieldAccessorWriter(TypeKind.DECLARED, true, "java.lang.Double", "writeDouble", "readDouble"));
        FieldAccessorWriterManager.addAccessor(new ArrayFieldAccessorWriter(TypeKind.DECLARED, false, "java.lang.String", "writeString", "readString"));
        FieldAccessorWriterManager.addAccessor(new ArrayFieldAccessorWriter(TypeKind.DECLARED, true, "java.lang.String", "writeString", "readString"));
        FieldAccessorWriterManager.addAccessor(new ArrayFieldAccessorWriter(TypeKind.ARRAY, false, "byte[]", "writeBytes", "readBytes"));
        FieldAccessorWriterManager.addAccessor(new ArrayFieldAccessorWriter(TypeKind.ARRAY, true, "byte[]", "writeBytes", "readBytes"));
        FieldAccessorWriterManager.addAccessor(new ArrayFieldAccessorWriter(TypeKind.ARRAY, false, "short[]", "writeShorts", "readShorts"));
        FieldAccessorWriterManager.addAccessor(new ArrayFieldAccessorWriter(TypeKind.ARRAY, true, "short[]", "writeShorts", "readShorts"));
        FieldAccessorWriterManager.addAccessor(new ArrayFieldAccessorWriter(TypeKind.ARRAY, false, "char[]", "writeChars", "readChars"));
        FieldAccessorWriterManager.addAccessor(new ArrayFieldAccessorWriter(TypeKind.ARRAY, true, "char[]", "writeChars", "readChars"));
        FieldAccessorWriterManager.addAccessor(new ArrayFieldAccessorWriter(TypeKind.ARRAY, false, "int[]", "writeInts", "readInts"));
        FieldAccessorWriterManager.addAccessor(new ArrayFieldAccessorWriter(TypeKind.ARRAY, true, "int[]", "writeInts", "readInts"));
        FieldAccessorWriterManager.addAccessor(new ArrayFieldAccessorWriter(TypeKind.ARRAY, false, "float[]", "writeFloats", "readFloats"));
        FieldAccessorWriterManager.addAccessor(new ArrayFieldAccessorWriter(TypeKind.ARRAY, true, "float[]", "writeFloats", "readFloats"));
        FieldAccessorWriterManager.addAccessor(new ArrayFieldAccessorWriter(TypeKind.ARRAY, false, "double[]", "writeDoubles", "readDoubles"));
        FieldAccessorWriterManager.addAccessor(new ArrayFieldAccessorWriter(TypeKind.ARRAY, true, "double[]", "writeDoubles", "readDoubles"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, false, "java.lang.Byte", "writeByte", "readByte"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, true, "java.lang.Byte", "writeByte", "readByte"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, false, "java.lang.Short", "writeShort", "readShort"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, true, "java.lang.Short", "writeShort", "readShort"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, false, "java.lang.Character", "writeChar", "readChar"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, true, "java.lang.Character", "writeChar", "readChar"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, false, "java.lang.Integer", "writeInt", "readInt"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, true, "java.lang.Integer", "writeInt", "readInt"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, false, "java.lang.Float", "writeFloat", "readFloat"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, true, "java.lang.Float", "writeFloat", "readFloat"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, false, "java.lang.Double", "writeDouble", "readDouble"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, true, "java.lang.Double", "writeDouble", "readDouble"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, false, "java.lang.String", "writeString", "readString"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, true, "java.lang.String", "writeString", "readString"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, false, "java.lang.Object", "writeObject", "readObject"));
        FieldAccessorWriterManager.addAccessor(new ObjectArrayFieldAccessorWriter(TypeKind.ARRAY, true, "java.lang.Object", "writeObject", "readObject"));
    }
}

