/*
 * Decompiled with CFR 0.152.
 */
package org.gittorr.ccerial.utils.impl;

import java.io.IOException;
import java.io.Writer;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import org.gittorr.ccerial.AccessorType;
import org.gittorr.ccerial.CcArray;
import org.gittorr.ccerial.CcSerializable;
import org.gittorr.ccerial.utils.impl.AbstractFieldAccessorWriter;
import org.stringtemplate.v4.ST;

public class ArrayFieldAccessorWriter
extends AbstractFieldAccessorWriter {
    final String writerMethodName;
    final String readerMethodName;

    public ArrayFieldAccessorWriter(TypeKind kind, boolean variable, String typeName, String writerMethodName, String readerMethodName) {
        super(kind, variable, typeName);
        this.writerMethodName = writerMethodName;
        this.readerMethodName = readerMethodName;
    }

    @Override
    public void writeWriter(Writer out, String accessorName, Element fieldEl, CcSerializable ccSerializable, boolean isRecord) throws IOException {
        boolean isSstring;
        String variableCount = ", obj." + accessorName + ".length";
        CcArray annotation = fieldEl.getAnnotation(CcArray.class);
        boolean nullIsEmpty = ccSerializable.nullIsZeroOrEmpty();
        String charset = "UTF-8";
        if (annotation != null) {
            variableCount = ", " + annotation.count();
            charset = annotation.stringCharsetName();
        }
        String typeName = fieldEl.asType().toString();
        boolean stringAsWchar = annotation != null && annotation.stringAsCharArray() && typeName.equals("java.lang.String");
        boolean bl = isSstring = (annotation == null || !annotation.stringAsCharArray()) && typeName.equals("java.lang.String");
        if (nullIsEmpty && this.variable) {
            out.write("\t\tif (BinaryUtils.isNullOrEmpty(obj." + accessorName + "))\n\t\t\tout.write(0);\n\t\telse\n\t");
        }
        out.write("\t\tBinaryUtils." + (stringAsWchar ? "writeChars" : this.writerMethodName) + "(out, obj." + accessorName + (stringAsWchar ? ".toCharArray()" : "") + (String)(this.variable ? "" : variableCount) + (String)(!isSstring ? "" : ", \"" + charset + "\"") + ");\n");
    }

    @Override
    public void writeReader(Writer out, String accessorName, Element fieldEl, CcSerializable ccSerializable, boolean isRecord) throws IOException {
        Object variableCount = "";
        String charset = "UTF-8";
        CcArray annotation = fieldEl.getAnnotation(CcArray.class);
        String ctorArgName = this.toCtorArgName(accessorName, isRecord);
        String setterName = this.toSetterName(accessorName, isRecord);
        if (annotation != null) {
            variableCount = ", " + annotation.count();
            charset = annotation.stringCharsetName();
        }
        String typeName = fieldEl.asType().toString();
        boolean stringAsWchar = annotation != null && annotation.stringAsCharArray() && typeName.equals("java.lang.String");
        boolean isString = (annotation == null || !annotation.stringAsCharArray()) && typeName.equals("java.lang.String");
        String template = "\t\t<if(ctor)><typeName> <ctorArgName> = <else>obj.<setterName>(<endif><if(stringAsWchar)>new String(<endif>BinaryUtils.<readerMethodName>(in<variableCount><if(isString)>, \"<charset>\"<endif>)<if(stringAsWchar)>)<endif><if(!ctor)>)<endif>;\n";
        ST st = new ST(template);
        st.add("variable", (Object)this.variable);
        st.add("stringAsWchar", (Object)stringAsWchar);
        st.add("isString", (Object)isString);
        st.add("charset", (Object)charset);
        st.add("accessorName", (Object)accessorName);
        st.add("variableCount", variableCount);
        st.add("typeName", (Object)typeName);
        st.add("ctorArgName", (Object)ctorArgName);
        st.add("setterName", (Object)setterName);
        st.add("ctor", (Object)(ccSerializable.accessorType() == AccessorType.CONSTRUCTOR ? 1 : 0));
        st.add("readerMethodName", (Object)(stringAsWchar ? "readChars" : this.readerMethodName));
        out.write(st.render());
    }
}

