/*
 * Decompiled with CFR 0.152.
 */
package org.gittorr.ccerial.utils.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.type.TypeKind;
import org.gittorr.ccerial.utils.FieldAccessorWriter;

public abstract class AbstractFieldAccessorWriter
implements FieldAccessorWriter {
    final TypeKind kind;
    final boolean variable;
    final String typeName;
    private static final Pattern ACC_PAT = Pattern.compile("^(set|get)(\\w+)\\(.*?");
    private static final Pattern RACC_PAT = Pattern.compile("^(\\w+)\\(.*?");

    public AbstractFieldAccessorWriter(TypeKind kind, boolean variable, String typeName) {
        this.kind = kind;
        this.variable = variable;
        this.typeName = typeName;
    }

    @Override
    public TypeKind getKind() {
        return this.kind;
    }

    @Override
    public boolean isVariable() {
        return this.variable;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractFieldAccessorWriter)) {
            return false;
        }
        AbstractFieldAccessorWriter that = (AbstractFieldAccessorWriter)o;
        if (this.variable != that.variable) {
            return false;
        }
        return this.kind == that.kind && this.typeName.equals(that.typeName);
    }

    public int hashCode() {
        int result = this.typeName.hashCode() * 31 + this.kind.hashCode();
        result = 31 * result + (this.variable ? 1 : 0);
        return result;
    }

    protected String toCtorArgName(String accessorName, boolean isRecord) {
        Matcher m = (isRecord ? RACC_PAT : ACC_PAT).matcher(accessorName);
        if (m.matches()) {
            return "arg" + this.fstUp(m.group(isRecord ? 1 : 2));
        }
        throw new RuntimeException("Error converting constructor argument name");
    }

    private String fstUp(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    protected String toSetterName(String accessorName, boolean isRecord) {
        Matcher m = (isRecord ? RACC_PAT : ACC_PAT).matcher(accessorName);
        if (m.matches()) {
            return (isRecord ? "" : "set") + m.group(isRecord ? 1 : 2);
        }
        throw new RuntimeException("Error converting setter name");
    }
}

