/*
 * Decompiled with CFR 0.152.
 */
package org.gittorr.ccerial.utils.impl;

import java.io.IOException;
import java.io.Writer;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import org.gittorr.ccerial.AccessorType;
import org.gittorr.ccerial.CcSerializable;
import org.gittorr.ccerial.CcValue;
import org.gittorr.ccerial.utils.FieldAccessorWriterManager;
import org.gittorr.ccerial.utils.impl.AbstractFieldAccessorWriter;
import org.stringtemplate.v4.ST;

public class SimpleFieldAccessorWriter
extends AbstractFieldAccessorWriter {
    final String writerMethodName;
    final String readerMethodName;

    public SimpleFieldAccessorWriter(TypeKind kind, boolean variable, String typeName, String writerMethodName, String readerMethodName) {
        super(kind, variable, typeName);
        this.writerMethodName = writerMethodName;
        this.readerMethodName = readerMethodName;
    }

    @Override
    public void writeWriter(Writer out, String accessorName, Element fieldEl, CcSerializable ccSerializable, boolean isRecord) throws IOException {
        boolean nullIsZero = ccSerializable.nullIsZeroOrEmpty();
        CcValue valueAnnot = fieldEl.getAnnotation(CcValue.class);
        if (valueAnnot != null && !fieldEl.asType().getKind().isPrimitive()) {
            nullIsZero = valueAnnot.nullIsZeroOrEmpty();
        }
        out.write("\t\tBinaryUtils." + this.writerMethodName);
        out.write(String.format(nullIsZero ? "(out, BinaryUtils.zeroIfNull(obj.%s));\n" : "(out, obj.%s);\n", accessorName));
    }

    @Override
    public void writeReader(Writer out, String accessorName, Element fieldEl, CcSerializable ccSerializable, boolean isRecord) throws IOException {
        String ctorArgName = this.toCtorArgName(accessorName, isRecord);
        String setterName = this.toSetterName(accessorName, isRecord);
        String typeName = FieldAccessorWriterManager.getTypeName(fieldEl.asType());
        String template = "\t\t<if(ctor)><typeName> <ctorArgName> = <else>obj.<setterName>(<endif>BinaryUtils.<readerMethodName>(in)<if(!ctor)>)<endif>;\n";
        ST st = new ST(template);
        st.add("variable", (Object)this.variable);
        st.add("accessorName", (Object)accessorName);
        st.add("typeName", (Object)typeName);
        st.add("ctorArgName", (Object)ctorArgName);
        st.add("setterName", (Object)setterName);
        st.add("ctor", (Object)(ccSerializable.accessorType() == AccessorType.CONSTRUCTOR ? 1 : 0));
        st.add("readerMethodName", (Object)this.readerMethodName);
        out.write(st.render());
    }
}

