/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.authentication;

import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class TOTP {
    private static final int[] DIGITS_POWER = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};

    private TOTP() {
    }

    private static byte[] hmacSha(String crypto, byte[] keyBytes, byte[] text) {
        try {
            Mac hmac = Mac.getInstance(crypto);
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
            hmac.init(macKey);
            return hmac.doFinal(text);
        }
        catch (GeneralSecurityException gse) {
            throw new UndeclaredThrowableException(gse);
        }
    }

    public static int generateTOTP(byte[] key, long time, int digits, String crypto) {
        byte[] msg = ByteBuffer.allocate(8).putLong(time).array();
        byte[] hash = TOTP.hmacSha(crypto, key, msg);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = binary % DIGITS_POWER[digits];
        return otp;
    }
}

