/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.authentication;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.codec.binary.Base32;
import org.gjgr.pig.chivalrous.core.authentication.TOTP;

public class TOTPCommand {
    private static final int SECRET_SIZE = 10;
    private static final int PASS_CODE_LENGTH = 6;
    private static final String CRYPTO = "HmacSHA1";
    private static final Random rand = new Random();
    private static final ThreadLocal<String> LOCAL_SECRET_KEY = new ThreadLocal();
    private static final long STEP = 30000L;
    private static final int CODE_DIGITS = 8;
    private static final long INITIAL_TIME = 0L;
    private static final long FLEXIBILIT_TIME = 5000L;
    private static final int[] DIGITS_POWER = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};

    public static String generateCommonSecret() {
        byte[] buffer = new byte[10];
        rand.nextBytes(buffer);
        Base32 codec = new Base32();
        byte[] secretKey = Arrays.copyOf(buffer, 10);
        byte[] encodedKey = codec.encode(secretKey);
        return new String(encodedKey);
    }

    public static boolean verifyCommonSecret(String secret, long code, int interval, int window) throws NoSuchAlgorithmException, InvalidKeyException {
        Base32 codec = new Base32();
        byte[] decodedKey = codec.decode(secret);
        long currentInterval = TOTPCommand.getCurrentInterval(interval);
        for (int i = -window; i <= window; ++i) {
            long hash = TOTP.generateTOTP(decodedKey, currentInterval + (long)i, 6, CRYPTO);
            if (hash != code) continue;
            return true;
        }
        return false;
    }

    private static long getCurrentInterval(int interval) {
        long currentTimeSeconds = System.currentTimeMillis() / 1000L;
        return currentTimeSeconds / (long)interval;
    }
}

