/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.authentication;

import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.gjgr.pig.chivalrous.core.lang.ObjectCommand;

public class TOTPHolder {
    private static final ThreadLocal<String> LOCAL_SECRET_KEY = new ThreadLocal();
    private static final long STEP = 60000L;
    private static final int CODE_DIGITS = 6;
    private static final long INITIAL_TIME = 0L;
    private static final long FLEXIBILIT_TIME = 5000L;
    private static final int[] DIGITS_POWER = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};

    public TOTPHolder(String secretKey) {
        LOCAL_SECRET_KEY.set(secretKey);
    }

    TOTPHolder() {
        LOCAL_SECRET_KEY.set("default");
    }

    public static void main(String[] args) {
        try {
            for (int j = 0; j < 10; ++j) {
                String totp = TOTPHolder.generateMyTOTP("account01", "12345");
                System.out.println(String.format("\u52a0\u5bc6\u540e: %s", totp));
                Thread.sleep(10000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String generateMyTOTP(String code, String pass) {
        if (ObjectCommand.isEmpty(code) || ObjectCommand.isEmpty(pass)) {
            throw new RuntimeException("target code and password should not null.");
        }
        long now = System.currentTimeMillis();
        String time = Long.toHexString(TOTPHolder.timeFactor(now)).toUpperCase();
        return TOTPHolder.generateTOTP(code + pass + LOCAL_SECRET_KEY.get(), time);
    }

    public static boolean verifyTOTPRigidity(String code, String password, String totp) {
        return TOTPHolder.generateMyTOTP(code, password).equals(totp);
    }

    public static boolean verifyTOTPFlexibility(String code, String password, String totp) {
        long now = System.currentTimeMillis();
        String time = Long.toHexString(TOTPHolder.timeFactor(now)).toUpperCase();
        String tempTotp = TOTPHolder.generateTOTP(code + password + LOCAL_SECRET_KEY.get(), time);
        if (tempTotp.equals(totp)) {
            return true;
        }
        String time2 = Long.toHexString(TOTPHolder.timeFactor(now - 5000L)).toUpperCase();
        String tempTotp2 = TOTPHolder.generateTOTP(code + password + LOCAL_SECRET_KEY.get(), time2);
        return tempTotp2.equals(totp);
    }

    private static long timeFactor(long targetTime) {
        return (targetTime - 0L) / 60000L;
    }

    private static byte[] hmac_sha(String crypto, byte[] keyBytes, byte[] text) {
        try {
            Mac hmac = Mac.getInstance(crypto);
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "AES");
            hmac.init(macKey);
            return hmac.doFinal(text);
        }
        catch (GeneralSecurityException gse) {
            throw new UndeclaredThrowableException(gse);
        }
    }

    private static byte[] hexStr2Bytes(String hex) {
        byte[] bArray = new BigInteger("10" + hex, 16).toByteArray();
        byte[] ret = new byte[bArray.length - 1];
        System.arraycopy(bArray, 1, ret, 0, ret.length);
        return ret;
    }

    private static String generateTOTP(String key, String time) {
        return TOTPHolder.generateTOTP(key, time, "HmacSHA1");
    }

    private static String generateTOTP256(String key, String time) {
        return TOTPHolder.generateTOTP(key, time, "HmacSHA256");
    }

    private static String generateTOTP512(String key, String time) {
        return TOTPHolder.generateTOTP(key, time, "HmacSHA512");
    }

    private static String generateTOTP(String key, String time, String crypto) {
        StringBuilder timeBuilder = new StringBuilder(time);
        while (timeBuilder.length() < 16) {
            timeBuilder.insert(0, "0");
        }
        time = timeBuilder.toString();
        byte[] msg = TOTPHolder.hexStr2Bytes(time);
        byte[] k = key.getBytes();
        byte[] hash = TOTPHolder.hmac_sha(crypto, k, msg);
        return TOTPHolder.truncate(hash);
    }

    private static String truncate(byte[] target) {
        int offset = target[target.length - 1] & 0xF;
        int binary = (target[offset] & 0x7F) << 24 | (target[offset + 1] & 0xFF) << 16 | (target[offset + 2] & 0xFF) << 8 | target[offset + 3] & 0xFF;
        int otp = binary % DIGITS_POWER[6];
        StringBuilder result = new StringBuilder(Integer.toString(otp));
        while (result.length() < 6) {
            result.insert(0, "0");
        }
        return result.toString();
    }
}

