/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.bloom;

import org.gjgr.pig.chivalrous.core.bloom.BloomFilter;
import org.gjgr.pig.chivalrous.core.bloom.filter.DefaultFilter;
import org.gjgr.pig.chivalrous.core.bloom.filter.ELFFilter;
import org.gjgr.pig.chivalrous.core.bloom.filter.JSFilter;
import org.gjgr.pig.chivalrous.core.bloom.filter.PJWFilter;
import org.gjgr.pig.chivalrous.core.bloom.filter.SDBMFilter;

public class BitMapBloomFilter
implements BloomFilter {
    private BloomFilter[] filters;

    public BitMapBloomFilter(int m) {
        float mNum = m / 5;
        long size = (long)(1.0f * mNum * 1024.0f * 1024.0f * 8.0f);
        this.filters = new BloomFilter[]{new DefaultFilter(size), new ELFFilter(size), new JSFilter(size), new PJWFilter(size), new SDBMFilter(size)};
    }

    public BitMapBloomFilter(int m, BloomFilter ... filters) {
        this.filters = filters;
    }

    @Override
    public boolean contains(String str) {
        for (BloomFilter filter : this.filters) {
            if (filter.contains(str)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(String str) {
        boolean flag = true;
        for (BloomFilter filter : this.filters) {
            flag |= filter.add(str);
        }
        return flag;
    }
}

