/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.cache.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.gjgr.pig.chivalrous.core.cache.Cache;
import org.gjgr.pig.chivalrous.core.cache.impl.CacheObj;
import org.gjgr.pig.chivalrous.core.cache.impl.CacheValuesIterator;

public abstract class AbstractCache<K, V>
implements Cache<K, V>,
Iterable<V> {
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.cacheLock.readLock();
    private final Lock writeLock = this.cacheLock.writeLock();
    protected Map<K, CacheObj<K, V>> cacheMap;
    protected int capacity;
    protected long timeout;
    protected boolean existCustomTimeout;
    protected int hitCount;
    protected int missCount;

    public int getHitCount() {
        return this.hitCount;
    }

    public int getMissCount() {
        return this.missCount;
    }

    protected abstract int pruneCache();

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public void put(K key, V object) {
        this.put(key, object, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V object, long timeout) {
        this.writeLock.lock();
        try {
            CacheObj<K, V> co = new CacheObj<K, V>(key, object, timeout);
            if (timeout != 0L) {
                this.existCustomTimeout = true;
            }
            if (this.isFull()) {
                this.pruneCache();
            }
            this.cacheMap.put(key, co);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.readLock.lock();
        try {
            CacheObj<K, V> co = this.cacheMap.get(key);
            if (co == null) {
                ++this.missCount;
                V v = null;
                return v;
            }
            if (co.isExpired()) {
                this.cacheMap.remove(key);
                ++this.missCount;
                V v = null;
                return v;
            }
            ++this.hitCount;
            V v = co.get();
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Iterator<V> iterator() {
        return new CacheValuesIterator(this);
    }

    @Override
    public final int prune() {
        this.writeLock.lock();
        try {
            int n = this.pruneCache();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean isFull() {
        return this.capacity > 0 && this.cacheMap.size() >= this.capacity;
    }

    @Override
    public void remove(K key) {
        CacheObj<K, V> co;
        this.writeLock.lock();
        try {
            co = this.cacheMap.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
        if (null != co) {
            this.onRemove(co.key, co.obj);
        }
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.cacheMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cacheMap.isEmpty();
    }

    protected boolean isPruneExpiredActive() {
        return this.timeout != 0L || this.existCustomTimeout;
    }

    public String toString() {
        return this.cacheMap.toString();
    }

    protected void onRemove(K key, V cachedObject) {
    }
}

