/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.convert;

import java.text.MessageFormat;
import org.gjgr.pig.chivalrous.core.convert.Converter;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.ClassCommand;

public abstract class AbstractConverter<T>
implements Converter<T> {
    @Override
    public T convert(Object value, T defaultValue) {
        Class<Object> targetType = this.getTargetType();
        if (null == targetType && null == defaultValue) {
            throw new NullPointerException("[type] and [defaultValue] are both null for Converter [" + this.getClass() + "], we can not know what type to convert !");
        }
        if (null == targetType) {
            targetType = defaultValue.getClass();
        }
        if (targetType.isPrimitive()) {
            return this.convertInternal(value);
        }
        if (null == value) {
            return defaultValue;
        }
        if (null == defaultValue || targetType.isInstance(defaultValue)) {
            if (targetType.isInstance(value)) {
                return (T)targetType.cast(value);
            }
            T convertInternal = this.convertInternal(value);
            return null == convertInternal ? defaultValue : convertInternal;
        }
        throw new IllegalArgumentException(MessageFormat.format("Default value [{0}] is not the instance of [{1}]]", defaultValue, targetType));
    }

    protected abstract T convertInternal(Object var1);

    protected String convertToStr(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (ArrayCommand.isArray(value)) {
            return ArrayCommand.toString(value);
        }
        return value.toString();
    }

    public Class<T> getTargetType() {
        return ClassCommand.getTypeArgument(this.getClass());
    }
}

