/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gjgr.pig.chivalrous.core.convert.BasicType;
import org.gjgr.pig.chivalrous.core.convert.ConvertException;
import org.gjgr.pig.chivalrous.core.convert.ConverterRegistry;
import org.gjgr.pig.chivalrous.core.lang.AssertCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.math.HexCommand;
import org.gjgr.pig.chivalrous.core.nio.CharsetCommand;

public final class Convert {
    private Convert() {
    }

    public static String toStr(Object value, String defaultValue) {
        return Convert.convert(String.class, value, defaultValue);
    }

    public static String toStr(Object value) {
        return Convert.toStr(value, null);
    }

    public static Character toChar(Object value, Character defaultValue) {
        return Convert.convert(Character.class, value, defaultValue);
    }

    public static Character toChar(Object value) {
        return Convert.toChar(value, null);
    }

    public static Byte toByte(Object value, Byte defaultValue) {
        return Convert.convert(Byte.class, value, defaultValue);
    }

    public static Byte toByte(Object value) {
        return Convert.toByte(value, null);
    }

    public static Short toShort(Object value, Short defaultValue) {
        return Convert.convert(Short.class, value, defaultValue);
    }

    public static Short toShort(Object value) {
        return Convert.toShort(value, null);
    }

    public static Number toNumber(Object value, Number defaultValue) {
        return Convert.convert(Number.class, value, defaultValue);
    }

    public static Number toNumber(Object value) {
        return Convert.toNumber(value, null);
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        return Convert.convert(Integer.class, value, defaultValue);
    }

    public static Integer toInt(Object value) {
        return Convert.toInt(value, null);
    }

    public static Integer[] toIntArray(Object value) {
        return Convert.convert(Integer[].class, value);
    }

    public static Long toLong(Object value, Long defaultValue) {
        return Convert.convert(Long.class, value, defaultValue);
    }

    public static Long toLong(Object value) {
        return Convert.toLong(value, null);
    }

    public static Long[] toLongArray(Object value) {
        return Convert.convert(Long[].class, value);
    }

    public static Double toDouble(Object value, Double defaultValue) {
        return Convert.convert(Double.class, value, defaultValue);
    }

    public static Double toDouble(Object value) {
        return Convert.toDouble(value, null);
    }

    public static Double[] toDoubleArray(Object value) {
        return Convert.convert(Double[].class, value);
    }

    public static Float toFloat(Object value, Float defaultValue) {
        return Convert.convert(Float.class, value, defaultValue);
    }

    public static Float toFloat(Object value) {
        return Convert.toFloat(value, null);
    }

    public static <T> Float[] toFloatArray(Object value) {
        return Convert.convert(Float[].class, value);
    }

    public static Boolean toBool(Object value, Boolean defaultValue) {
        return Convert.convert(Boolean.class, value, defaultValue);
    }

    public static Boolean toBool(Object value) {
        return Convert.toBool(value, null);
    }

    public static Boolean[] toBooleanArray(Object value) {
        return Convert.convert(Boolean[].class, value);
    }

    public static BigInteger toBigInteger(Object value, BigInteger defaultValue) {
        return Convert.convert(BigInteger.class, value, defaultValue);
    }

    public static BigInteger toBigInteger(Object value) {
        return Convert.toBigInteger(value, null);
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        return Convert.convert(BigDecimal.class, value, defaultValue);
    }

    public static BigDecimal toBigDecimal(Object value) {
        return Convert.toBigDecimal(value, null);
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value, E defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            Enum myE = (Enum)value;
            return (E)myE;
        }
        String valueStr = Convert.toStr(value, null);
        if (StringCommand.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(clazz, valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value) {
        return Convert.toEnum(clazz, value, null);
    }

    public static <T> T convert(Class<T> type, Object value) {
        return Convert.convert(type, value, null);
    }

    public static <T> T convert(Class<T> type, Object value, T defaultValue) throws ConvertException {
        return ConverterRegistry.getInstance().convert(type, value, defaultValue);
    }

    public static String toSBC(String input) {
        return Convert.toSBC(input, null);
    }

    public static String toSBC(String input, Set<Character> notConvertSet) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toDBC(String input) {
        return Convert.toDBC(input, null);
    }

    public static String toDBC(String text, Set<Character> notConvertSet) {
        char[] c = text.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        String returnString = new String(c);
        return returnString;
    }

    public static String toHex(String str, Charset charset) {
        return HexCommand.encodeHexStr(str.getBytes(charset));
    }

    public static String toHex(byte[] bytes) {
        return HexCommand.encodeHexStr(bytes);
    }

    public static byte[] hexToBytes(String src) {
        return HexCommand.decodeHex(src.toCharArray());
    }

    public static String hexStrToStr(String hexStr, Charset charset) {
        return HexCommand.decodeHexStr(hexStr, charset);
    }

    public static String strToUnicode(String strText) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < strText.length(); ++i) {
            char c;
            char intAsc = c = strText.charAt(i);
            String strHex = Integer.toHexString(intAsc);
            if (intAsc > '\u0080') {
                str.append("\\u" + strHex);
                continue;
            }
            str.append("\\u00" + strHex);
        }
        return str.toString();
    }

    public static String unicodeToStr(String hex) {
        int t = hex.length() / 6;
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < t; ++i) {
            String s = hex.substring(i * 6, (i + 1) * 6);
            String s1 = s.substring(2, 4) + "00";
            String s2 = s.substring(4);
            int n = Integer.valueOf(s1, 16) + Integer.valueOf(s2, 16);
            char[] chars = Character.toChars(n);
            str.append(new String(chars));
        }
        return str.toString();
    }

    public static String convertCharset(String str, String sourceCharset, String destCharset) {
        if (StringCommand.hasBlank(str, sourceCharset, destCharset)) {
            return str;
        }
        return CharsetCommand.convert(str, sourceCharset, destCharset);
    }

    public static long convertTime(long sourceDuration, TimeUnit sourceUnit, TimeUnit destUnit) {
        AssertCommand.notNull((Object)sourceUnit, "sourceUnit is null !");
        AssertCommand.notNull((Object)destUnit, "destUnit is null !");
        return destUnit.convert(sourceDuration, sourceUnit);
    }

    public static String digitUppercase(double n) {
        String[] fraction = new String[]{"\u89d2", "\u5206"};
        String[] digit = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[][] unit = new String[][]{{"\u5143", "\u4e07", "\u4ebf"}, {"", "\u62fe", "\u4f70", "\u4edf"}};
        String head = n < 0.0 ? "\u8d1f" : "";
        n = Math.abs(n);
        String s = "";
        for (int i = 0; i < fraction.length; ++i) {
            s = s + (digit[(int)(Math.floor(n * 10.0 * Math.pow(10.0, i)) % 10.0)] + fraction[i]).replaceAll("(\u96f6.)+", "");
        }
        if (s.length() < 1) {
            s = "\u6574";
        }
        int integerPart = (int)Math.floor(n);
        for (int i = 0; i < unit[0].length && integerPart > 0; ++i) {
            String p = "";
            for (int j = 0; j < unit[1].length && n > 0.0; ++j) {
                p = digit[integerPart % 10] + unit[1][j] + p;
                integerPart /= 10;
            }
            s = p.replaceAll("(\u96f6.)*\u96f6$", "").replaceAll("^$", "\u96f6") + unit[0][i] + s;
        }
        return head + s.replaceAll("(\u96f6.)*\u96f6\u5143", "\u5143").replaceFirst("(\u96f6.)+", "").replaceAll("(\u96f6.)+", "\u96f6").replaceAll("^\u6574$", "\u96f6\u5143\u6574");
    }

    public static Class<?> wrap(Class<?> clazz) {
        return BasicType.wrap(clazz);
    }

    public static Class<?> unWrap(Class<?> clazz) {
        return BasicType.unWrap(clazz);
    }
}

