/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.convert.impl;

import java.util.Calendar;
import org.gjgr.pig.chivalrous.core.convert.AbstractConverter;
import org.gjgr.pig.chivalrous.core.date.DateTime;
import org.gjgr.pig.chivalrous.core.date.DateTimeCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;

public class DateTimeConverter
extends AbstractConverter<DateTime> {
    private String format;

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected DateTime convertInternal(Object value) {
        if (value instanceof Calendar) {
            return new DateTime(((Calendar)value).getTime().getTime());
        }
        if (value instanceof Long) {
            return new DateTime((Long)value);
        }
        String valueStr = this.convertToStr(value);
        try {
            long date = StringCommand.isBlank(this.format) ? DateTimeCommand.parse(valueStr).getTime() : DateTimeCommand.parse(valueStr, this.format).getTime();
            return new DateTime(date);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

