/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.cron;

import org.gjgr.pig.chivalrous.core.cron.Scheduler;
import org.gjgr.pig.chivalrous.core.cron.task.Task;
import org.gjgr.pig.chivalrous.core.exceptions.UtilException;
import org.gjgr.pig.chivalrous.core.setting.Setting;
import org.gjgr.pig.chivalrous.core.setting.SettingRuntimeException;

public final class CronUtil {
    public static final String CRONTAB_CONFIG_PATH = "config/cron.setting";
    private static final Scheduler scheduler = new Scheduler();
    private static Setting crontabSetting;

    private CronUtil() {
    }

    public static void setCronSetting(Setting cronSetting) {
        crontabSetting = cronSetting;
    }

    public static void setCronSetting(String cronSettingPath) {
        try {
            crontabSetting = new Setting(cronSettingPath, Setting.DEFAULT_CHARSET, false);
        }
        catch (SettingRuntimeException settingRuntimeException) {
            // empty catch block
        }
    }

    public static void setMatchSecond(boolean isMatchSecond) {
        scheduler.setMatchSecond(isMatchSecond);
    }

    public static void setMatchYear(boolean isMatchYear) {
        scheduler.setMatchYear(isMatchYear);
    }

    public static String schedule(String schedulingPattern, Task task) {
        return scheduler.schedule(schedulingPattern, task);
    }

    public static String schedule(String schedulingPattern, Runnable task) {
        return scheduler.schedule(schedulingPattern, task);
    }

    public static void schedule(Setting cronSetting) {
        scheduler.schedule(cronSetting);
    }

    public static synchronized void start() {
        if (null == crontabSetting) {
            CronUtil.setCronSetting(CRONTAB_CONFIG_PATH);
        }
        if (scheduler.isStarted()) {
            throw new UtilException("Scheduler has been started, please stop it first!");
        }
        CronUtil.schedule(crontabSetting);
        scheduler.start();
    }

    public static synchronized void restart() {
        if (null != crontabSetting) {
            crontabSetting.load();
        }
        if (scheduler.isStarted()) {
            scheduler.stop();
        }
        CronUtil.schedule(crontabSetting);
        scheduler.start();
    }

    public static synchronized void stop() {
        scheduler.stop();
    }

    public void remove(String schedulerId) {
        scheduler.deschedule(schedulerId);
    }

    public Scheduler getScheduler() {
        return scheduler;
    }
}

