/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.cron.pattern.matcher;

import java.util.ArrayList;
import java.util.List;
import org.gjgr.pig.chivalrous.core.cron.CronException;
import org.gjgr.pig.chivalrous.core.cron.pattern.matcher.AlwaysTrueValueMatcher;
import org.gjgr.pig.chivalrous.core.cron.pattern.matcher.BoolArrayValueMatcher;
import org.gjgr.pig.chivalrous.core.cron.pattern.matcher.DayOfMonthValueMatcher;
import org.gjgr.pig.chivalrous.core.cron.pattern.matcher.ValueMatcher;
import org.gjgr.pig.chivalrous.core.cron.pattern.matcher.YearValueMatcher;
import org.gjgr.pig.chivalrous.core.cron.pattern.parser.DayOfMonthValueParser;
import org.gjgr.pig.chivalrous.core.cron.pattern.parser.ValueParser;
import org.gjgr.pig.chivalrous.core.cron.pattern.parser.YearValueParser;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.math.NumberCommand;

public class ValueMatcherBuilder {
    public static ValueMatcher build(String value, ValueParser parser) {
        if (value.length() == 1 && "*".equals(value)) {
            return new AlwaysTrueValueMatcher();
        }
        List<Integer> values = ValueMatcherBuilder.parseArray(value, parser);
        if (values.size() == 0) {
            throw new CronException("Invalid field: [{}]", value);
        }
        if (parser instanceof DayOfMonthValueParser) {
            return new DayOfMonthValueMatcher(values);
        }
        if (parser instanceof YearValueParser) {
            return new YearValueMatcher(values);
        }
        return new BoolArrayValueMatcher(values);
    }

    private static List<Integer> parseArray(String value, ValueParser parser) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        List<String> parts = StringCommand.split(value, ',');
        for (String part : parts) {
            CollectionCommand.addAllIfNotContains(values, ValueMatcherBuilder.parseStep(part, parser));
        }
        return values;
    }

    private static List<Integer> parseStep(String value, ValueParser parser) {
        List<String> parts = StringCommand.split(value, '/');
        int size = parts.size();
        if (size == 1) {
            return ValueMatcherBuilder.parseRange(value, parser);
        }
        if (size == 2) {
            List<Integer> rangeValues = ValueMatcherBuilder.parseRange(parts.get(0), parser);
            int step = parser.parse(parts.get(1));
            if (step < 1) {
                throw new CronException("Non positive divisor for field: [{}]", value);
            }
            ArrayList<Integer> values2 = new ArrayList<Integer>();
            for (int i = 0; i < rangeValues.size(); i += step) {
                values2.add(rangeValues.get(i));
            }
            return values2;
        }
        throw new CronException("Invalid syntax of field: [{}]", value);
    }

    private static List<Integer> parseRange(String value, ValueParser parser) {
        if (value.length() == 1 && "*".equals(value)) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            for (int i = parser.getMin(); i <= parser.getMax(); ++i) {
                values.add(i);
            }
            return values;
        }
        List<String> parts = StringCommand.split(value, '-');
        int size = parts.size();
        ArrayList<Integer> values = new ArrayList<Integer>();
        if (size == 1) {
            values.add(parser.parse(value));
            return values;
        }
        if (size == 2) {
            int v2;
            int v1 = parser.parse(parts.get(0));
            if (v1 < (v2 = parser.parse(parts.get(1)))) {
                NumberCommand.appendRange(v1, v2, values);
            } else if (v1 > v2) {
                NumberCommand.appendRange(v1, parser.getMax(), values);
                NumberCommand.appendRange(parser.getMin(), v2, values);
            } else {
                values.add(v1);
            }
        } else {
            throw new CronException("Invalid syntax of field: [{}]", value);
        }
        return values;
    }
}

