/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.crypto;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.gjgr.pig.chivalrous.core.crypto.compression.GjgrGZIPInputStream;
import org.gjgr.pig.chivalrous.core.exceptions.UtilException;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;
import org.gjgr.pig.chivalrous.core.io.stream.FastByteArrayOutputStream;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;

public final class DCompressionCommand {
    private DCompressionCommand() {
    }

    public static File zip(String srcPath) throws IOException {
        return DCompressionCommand.zip(FileCommand.file(srcPath));
    }

    public static File zip(File srcFile) throws IOException {
        File zipFile = FileCommand.file(srcFile.getParentFile(), FileCommand.mainName(srcFile) + ".zip");
        DCompressionCommand.zip(zipFile, false, srcFile);
        return zipFile;
    }

    public static File zip(String srcPath, String zipPath) throws IOException {
        return DCompressionCommand.zip(srcPath, zipPath, false);
    }

    public static File zip(String srcPath, String zipPath, boolean withSrcDir) throws IOException {
        File srcFile = FileCommand.file(srcPath);
        File zipFile = FileCommand.file(zipPath);
        DCompressionCommand.zip(zipFile, withSrcDir, srcFile);
        return zipFile;
    }

    public static void zip(File zipFile, boolean withSrcDir, File ... srcFiles) throws IOException {
        DCompressionCommand.validateFiles(zipFile, srcFiles);
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new CheckedOutputStream(FileCommand.bufferedOutputStream(zipFile), new CRC32()));
            for (File srcFile : srcFiles) {
                String srcRootDir = srcFile.getCanonicalPath();
                if (srcFile.isFile() || withSrcDir) {
                    srcRootDir = srcFile.getParent();
                }
                DCompressionCommand.zip(out, srcRootDir, srcFile);
                out.flush();
            }
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IoCommand.close(out);
                throw throwable;
            }
        }
        IoCommand.close(out);
    }

    public static File unzip(File zipFile) throws IOException {
        return DCompressionCommand.unzip(zipFile, FileCommand.file(zipFile.getParentFile(), FileCommand.mainName(zipFile)));
    }

    public static File unzip(String zipFilePath) throws IOException {
        return DCompressionCommand.unzip(FileCommand.file(zipFilePath));
    }

    public static File unzip(String zipFilePath, String outFileDir) throws IOException {
        return DCompressionCommand.unzip(FileCommand.file(zipFilePath), FileCommand.mkdir(outFileDir));
    }

    public static File unzip(File zipFile, File outFile) throws IOException {
        ZipFile zipFileObj = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> em = zipFileObj.entries();
        ZipEntry zipEntry = null;
        File outItemFile = null;
        while (em.hasMoreElements()) {
            zipEntry = em.nextElement();
            outItemFile = new File(outFile, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                outItemFile.mkdirs();
                continue;
            }
            FileCommand.touch(outItemFile);
            DCompressionCommand.copy(zipFileObj, zipEntry, outItemFile);
        }
        IoCommand.close(zipFileObj);
        return outFile;
    }

    public static byte[] gzip(String content, String charset) throws IOException {
        return DCompressionCommand.gzip(StringCommand.bytes(content, charset));
    }

    public static byte[] gzip(byte[] val) throws IOException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(val.length);
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(bos);
            gos.write(val, 0, val.length);
            gos.finish();
            gos.flush();
            val = bos.toByteArray();
        }
        catch (Throwable throwable) {
            IoCommand.close(gos);
            throw throwable;
        }
        IoCommand.close(gos);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzip(File file) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)file.length());
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(bos);
            BufferedInputStream in = FileCommand.bufferedInputStream(file);
            IoCommand.copy(in, gos);
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            IoCommand.close(gos);
            throw throwable;
        }
        IoCommand.close(gos);
        return byArray;
    }

    public static String unGzip(byte[] buf, String charset) throws IOException {
        return StringCommand.str(DCompressionCommand.unGzip(buf), charset);
    }

    public static ByteArrayOutputStream unGzip(String srcPath, String targetPath, String charset) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(srcPath));
        byte[] header = new byte[2];
        bis.mark(2);
        int result = bis.read(header);
        bis.reset();
        int ss = header[0] & 0xFF | (header[1] & 0xFF) << 8;
        Object in = null;
        if (result != -1 && ss == 35615) {
            return null;
        }
        return null;
    }

    public static byte[] unGzip(byte[] buf) throws IOException {
        return DCompressionCommand.unGzip2(buf).toByteArray();
    }

    private static ByteArrayOutputStream unGzip(InputStream inputStream, byte[] buf) throws IOException {
        ByteArrayOutputStream bos = null;
        bos = new ByteArrayOutputStream(buf.length);
        try {
            IoCommand.copy(inputStream, bos);
        }
        finally {
            IoCommand.close(inputStream);
        }
        return bos;
    }

    public static ByteArrayOutputStream unGzip2(byte[] buf) throws IOException {
        GZIPInputStream gzi = null;
        Object bos = null;
        try {
            gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
        }
        catch (Throwable throwable) {
            IoCommand.close(gzi);
            throw throwable;
        }
        IoCommand.close(gzi);
        return DCompressionCommand.unGzip(gzi, buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream unGzip(boolean withHeader, byte[] buf) throws IOException {
        if (withHeader) {
            return DCompressionCommand.unGzip2(buf);
        }
        GjgrGZIPInputStream gzi = null;
        Object bos = null;
        try {
            gzi = new GjgrGZIPInputStream(new ByteArrayInputStream(buf));
            gzi.trySetWithOutHeader();
        }
        catch (Throwable throwable) {
            IoCommand.close(gzi);
            throw throwable;
        }
        IoCommand.close(gzi);
        return DCompressionCommand.unGzip(gzi, buf);
    }

    public static byte[] unGzip(byte[] buf, boolean withHeader) throws IOException {
        return DCompressionCommand.unGzip(withHeader, buf).toByteArray();
    }

    private static void zip(ZipOutputStream out, String srcRootDir, File file) {
        block7: {
            block6: {
                if (file == null) {
                    return;
                }
                if (!file.isFile()) break block6;
                String subPath = FileCommand.subPath(srcRootDir, file);
                BufferedInputStream in = null;
                try {
                    out.putNextEntry(new ZipEntry(subPath));
                    in = FileCommand.bufferedInputStream(file);
                    IoCommand.copy(in, out);
                }
                catch (IOException e) {
                    try {
                        throw new UtilException(e);
                    }
                    catch (Throwable throwable) {
                        IoCommand.close(in);
                        DCompressionCommand.closeEntry(out);
                        throw throwable;
                    }
                }
                IoCommand.close(in);
                DCompressionCommand.closeEntry(out);
                break block7;
            }
            for (File childFile : file.listFiles()) {
                DCompressionCommand.zip(out, srcRootDir, childFile);
            }
        }
    }

    private static void validateFiles(File zipFile, File ... srcFiles) throws UtilException {
        for (File srcFile : srcFiles) {
            if (!srcFile.exists()) {
                throw new UtilException(StringCommand.format("File [{}] not isExist!", srcFile.getAbsolutePath()));
            }
            try {
                if (srcFile.isDirectory() && zipFile.getParent().contains(srcFile.getCanonicalPath())) {
                    throw new UtilException("[zipPath] must not be the child directory of [srcPath]!");
                }
                if (zipFile.exists()) continue;
                FileCommand.touch(zipFile);
            }
            catch (IOException e) {
                throw new UtilException(e);
            }
        }
    }

    private static void closeEntry(ZipOutputStream out) {
        try {
            out.closeEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(ZipFile zipFile, ZipEntry zipEntry, File outItemFile) throws IOException {
        InputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = zipFile.getInputStream(zipEntry);
            out = FileCommand.bufferedOutputStream(outItemFile);
            IoCommand.copy(in, out);
        }
        catch (Throwable throwable) {
            IoCommand.close(out);
            IoCommand.close(in);
            throw throwable;
        }
        IoCommand.close(out);
        IoCommand.close(in);
    }
}

