/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.crypto.asymmetric;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import org.gjgr.pig.chivalrous.core.crypto.CryptoCommand;
import org.gjgr.pig.chivalrous.core.crypto.CryptoException;
import org.gjgr.pig.chivalrous.core.crypto.asymmetric.AsymmetricType;
import org.gjgr.pig.chivalrous.core.crypto.asymmetric.KeyType;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.lang.Base64;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.nio.CharsetCommand;

public class AsymmetricCrypto {
    protected String algorithm;
    protected PublicKey publicKey;
    protected PrivateKey privateKey;
    protected Cipher clipher;
    protected Signature signature;
    protected Lock lock = new ReentrantLock();

    public AsymmetricCrypto(AsymmetricType algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public AsymmetricCrypto(String algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public AsymmetricCrypto(AsymmetricType algorithm, String privateKeyBase64, String publicKeyBase64) {
        this(algorithm.getValue(), Base64.decode(privateKeyBase64), Base64.decode(publicKeyBase64));
    }

    public AsymmetricCrypto(AsymmetricType algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public AsymmetricCrypto(String algorithm, String privateKeyBase64, String publicKeyBase64) {
        this(algorithm, Base64.decode(privateKeyBase64), Base64.decode(publicKeyBase64));
    }

    public AsymmetricCrypto(String algorithm, byte[] privateKey, byte[] publicKey) {
        this.init(algorithm, privateKey, publicKey);
    }

    public AsymmetricCrypto init(String algorithm, byte[] privateKey, byte[] publicKey) {
        this.algorithm = algorithm;
        try {
            this.clipher = Cipher.getInstance(algorithm);
            this.signature = Signature.getInstance("MD5with" + algorithm);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        if (null == privateKey && null == publicKey) {
            this.initKeys();
        } else {
            if (null != privateKey) {
                this.privateKey = CryptoCommand.privateKey(algorithm, privateKey);
            }
            if (null != publicKey) {
                this.publicKey = CryptoCommand.publicKey(algorithm, publicKey);
            }
        }
        return this;
    }

    public AsymmetricCrypto initKeys() {
        KeyPair keyPair = CryptoCommand.keyPair(this.algorithm);
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
        return this;
    }

    public byte[] sign(byte[] data) {
        try {
            this.signature.initSign(this.privateKey);
            this.signature.update(data);
            return this.signature.sign();
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public boolean verify(byte[] data, byte[] sign) {
        try {
            this.signature.initVerify(this.publicKey);
            this.signature.update(data);
            return this.signature.verify(sign);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public byte[] encrypt(byte[] data, KeyType keyType) {
        this.lock.lock();
        try {
            this.clipher.init(1, this.getKeyByType(keyType));
            byte[] byArray = this.clipher.doFinal(data);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] encrypt(String data, String charset, KeyType keyType) {
        return this.encrypt(StringCommand.bytes(data, charset), keyType);
    }

    public byte[] encrypt(String data, KeyType keyType) {
        return this.encrypt(StringCommand.bytes(data, CharsetCommand.CHARSET_UTF_8), keyType);
    }

    public byte[] encrypt(InputStream data, KeyType keyType) {
        try {
            return this.encrypt(IoCommand.readBytes(data), keyType);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    public byte[] decrypt(byte[] bytes, KeyType keyType) {
        this.lock.lock();
        try {
            this.clipher.init(2, this.getKeyByType(keyType));
            byte[] byArray = this.clipher.doFinal(bytes);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] decrypt(InputStream data, KeyType keyType) {
        try {
            return this.decrypt(IoCommand.readBytes(data), keyType);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public AsymmetricCrypto setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public String getPublicKeyBase64() {
        return Base64.encode(this.getPublicKey().getEncoded());
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public AsymmetricCrypto setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public String getPrivateKeyBase64() {
        return Base64.encode(this.getPrivateKey().getEncoded());
    }

    public Signature getSignature() {
        return this.signature;
    }

    public AsymmetricCrypto setSignature(Signature signature) {
        this.signature = signature;
        return this;
    }

    public Cipher getClipher() {
        return this.clipher;
    }

    protected Key getKeyByType(KeyType type) {
        switch (type) {
            case PrivateKey: {
                if (null == this.privateKey) {
                    throw new NullPointerException("Private key must not null when use it !");
                }
                return this.privateKey;
            }
            case PublicKey: {
                if (null == this.publicKey) {
                    throw new NullPointerException("Public key must not null when use it !");
                }
                return this.publicKey;
            }
        }
        throw new CryptoException("Uknown key type: " + (Object)((Object)type));
    }
}

