/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.crypto.compression;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class GjgrInflaterInputStream
extends FilterInputStream {
    protected Inflater inf;
    protected byte[] buf;
    protected int len;
    private boolean closed = false;
    private boolean reachEOF = false;
    boolean usesDefaultInflater = false;
    private byte[] singleByteBuf = new byte[1];
    private byte[] b = new byte[512];

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public GjgrInflaterInputStream(InputStream var1, Inflater var2, int var3) {
        super(var1);
        if (var1 != null && var2 != null) {
            if (var3 <= 0) {
                throw new IllegalArgumentException("buffer size <= 0");
            }
        } else {
            throw new NullPointerException();
        }
        this.inf = var2;
        this.buf = new byte[var3];
    }

    public GjgrInflaterInputStream(InputStream var1, Inflater var2) {
        this(var1, var2, 512);
    }

    public GjgrInflaterInputStream(InputStream var1) {
        this(var1, new Inflater());
        this.usesDefaultInflater = true;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.read(this.singleByteBuf, 0, 1) == -1 ? -1 : Byte.toUnsignedInt(this.singleByteBuf[0]);
    }

    @Override
    public int read(byte[] var1, int var2, int var3) throws IOException {
        this.ensureOpen();
        if (var1 == null) {
            throw new NullPointerException();
        }
        if (var2 >= 0 && var3 >= 0 && var3 <= var1.length - var2) {
            if (var3 == 0) {
                return 0;
            }
            try {
                int var4;
                while ((var4 = this.inf.inflate(var1, var2, var3)) == 0) {
                    if (this.inf.finished() || this.inf.needsDictionary()) {
                        this.reachEOF = true;
                        return -1;
                    }
                    if (!this.inf.needsInput()) continue;
                    this.fill();
                }
                return var4;
            }
            catch (DataFormatException var6) {
                String var5 = var6.getMessage();
                throw new ZipException(var5 != null ? var5 : "Invalid ZLIB data format");
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return this.reachEOF ? 0 : 1;
    }

    @Override
    public long skip(long var1) throws IOException {
        int var4;
        int var5;
        if (var1 < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.ensureOpen();
        int var3 = (int)Math.min(var1, Integer.MAX_VALUE);
        for (var4 = 0; var4 < var3; var4 += var5) {
            var5 = var3 - var4;
            if (var5 > this.b.length) {
                var5 = this.b.length;
            }
            if ((var5 = this.read(this.b, 0, var5)) != -1) continue;
            this.reachEOF = true;
            break;
        }
        return var4;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.usesDefaultInflater) {
                this.inf.end();
            }
            this.in.close();
            this.closed = true;
        }
    }

    protected void fill() throws IOException {
        this.ensureOpen();
        this.len = this.in.read(this.buf, 0, this.buf.length);
        if (this.len == -1) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.inf.setInput(this.buf, 0, this.len);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int var1) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

